/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.amqp.codec.auth;

import io.netty.channel.ChannelHandlerContext;
import io.netty.util.AttributeKey;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.wso2.broker.amqp.codec.auth.AuthenticationStrategy;
import org.wso2.broker.amqp.codec.frames.ConnectionSecure;
import org.wso2.broker.amqp.codec.frames.ConnectionTune;
import org.wso2.broker.amqp.codec.handlers.AmqpConnectionHandler;
import org.wso2.broker.auth.AuthManager;
import org.wso2.broker.common.data.types.LongString;
import org.wso2.broker.common.data.types.ShortString;
import org.wso2.broker.core.BrokerException;

public class SaslAuthenticationStrategy
implements AuthenticationStrategy {
    private AuthManager authManager;
    public static final String SASL_SERVER_ATTRIBUTE = "broker.sasl.server";

    SaslAuthenticationStrategy(AuthManager authManager) {
        this.authManager = authManager;
    }

    @Override
    public void handle(int channel, ChannelHandlerContext ctx, AmqpConnectionHandler connectionHandler, ShortString mechanism, LongString response) throws BrokerException {
        try {
            SaslServer saslServer = this.authManager.createSaslServer(connectionHandler.getConfiguration().getHostName(), mechanism.toString());
            byte[] challenge = saslServer.evaluateResponse(response.getBytes());
            if (saslServer.isComplete()) {
                ctx.writeAndFlush((Object)new ConnectionTune(256, 65535L, 0));
            } else {
                ctx.channel().attr(AttributeKey.valueOf((String)SASL_SERVER_ATTRIBUTE)).set((Object)saslServer);
                ctx.writeAndFlush((Object)new ConnectionSecure(channel, LongString.parse((byte[])challenge)));
            }
        }
        catch (SaslException e) {
            throw new BrokerException("Exception occurred while handling authentication with Sasl", (Throwable)e);
        }
    }
}

