/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.amqp.codec.frames;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.broker.amqp.codec.frames.AmqMethodBodyFactory;
import org.wso2.broker.amqp.codec.frames.MethodFrame;
import org.wso2.broker.amqp.codec.handlers.AmqpConnectionHandler;
import org.wso2.broker.common.data.types.ShortString;

public class BasicConsumeOk
extends MethodFrame {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicConsumeOk.class);
    private final ShortString consumerTag;

    public BasicConsumeOk(int channel, ShortString consumerTag) {
        super(channel, (short)60, (short)21);
        this.consumerTag = consumerTag;
    }

    @Override
    protected long getMethodBodySize() {
        return this.consumerTag.getSize();
    }

    @Override
    protected void writeMethod(ByteBuf buf) {
        this.consumerTag.write(buf);
    }

    @Override
    public void handle(ChannelHandlerContext ctx, AmqpConnectionHandler connectionHandler) {
    }

    public static AmqMethodBodyFactory getFactory() {
        return (buf, channel, size) -> {
            ShortString consumerTag = ShortString.parse((ByteBuf)buf);
            return new BasicConsumeOk(channel, consumerTag);
        };
    }
}

