/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.amqp.codec.frames;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import org.wso2.broker.amqp.codec.AmqpChannel;
import org.wso2.broker.amqp.codec.frames.AmqMethodBodyFactory;
import org.wso2.broker.amqp.codec.frames.ChannelClose;
import org.wso2.broker.amqp.codec.frames.ExchangeDeleteOk;
import org.wso2.broker.amqp.codec.frames.MethodFrame;
import org.wso2.broker.amqp.codec.handlers.AmqpConnectionHandler;
import org.wso2.broker.common.ValidationException;
import org.wso2.broker.common.data.types.ShortString;
import org.wso2.broker.core.BrokerException;

public class ExchangeDelete
extends MethodFrame {
    private static final short CLASS_ID = 40;
    private static final short METHOD_ID = 20;
    private final ShortString exchange;
    private final boolean ifUnused;

    private ExchangeDelete(int channel, ShortString exchangeName, boolean ifUnused) {
        super(channel, (short)40, (short)20);
        this.exchange = exchangeName;
        this.ifUnused = ifUnused;
    }

    @Override
    protected long getMethodBodySize() {
        return 2L + this.exchange.getSize() + 1L + 1L;
    }

    @Override
    protected void writeMethod(ByteBuf buf) {
        buf.writeShort(0);
        this.exchange.write(buf);
        buf.writeBoolean(this.ifUnused);
    }

    @Override
    public void handle(ChannelHandlerContext ctx, AmqpConnectionHandler connectionHandler) {
        AmqpChannel channel = connectionHandler.getChannel(this.getChannel());
        ctx.fireChannelRead(() -> {
            try {
                channel.deleteExchange(this.exchange.toString(), this.ifUnused);
                ctx.writeAndFlush((Object)new ExchangeDeleteOk(this.getChannel()));
            }
            catch (BrokerException e) {
                ctx.writeAndFlush((Object)new ChannelClose(this.getChannel(), 530, ShortString.parseString((String)e.getMessage()), 40, 20));
            }
            catch (ValidationException e) {
                ctx.writeAndFlush((Object)new ChannelClose(this.getChannel(), 406, ShortString.parseString((String)e.getMessage()), 40, 20));
            }
        });
    }

    public static AmqMethodBodyFactory getFactory() {
        return (buf, channel, size) -> {
            buf.skipBytes(2);
            ShortString exchangeName = ShortString.parse((ByteBuf)buf);
            boolean ifUnused = buf.readBoolean();
            return new ExchangeDelete(channel, exchangeName, ifUnused);
        };
    }
}

