/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.amqp.codec.frames;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.broker.amqp.codec.auth.AuthenticationStrategy;
import org.wso2.broker.amqp.codec.frames.AmqMethodBodyFactory;
import org.wso2.broker.amqp.codec.frames.ConnectionClose;
import org.wso2.broker.amqp.codec.frames.MethodFrame;
import org.wso2.broker.amqp.codec.handlers.AmqpConnectionHandler;
import org.wso2.broker.common.data.types.FieldTable;
import org.wso2.broker.common.data.types.LongString;
import org.wso2.broker.common.data.types.ShortString;
import org.wso2.broker.core.BrokerException;

public class ConnectionStartOk
extends MethodFrame {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionStartOk.class);
    private static final short CLASS_ID = 10;
    private static final short METHOD_ID = 11;
    private final FieldTable clientProperties;
    private final ShortString mechanism;
    private final ShortString locale;
    private final LongString response;
    private final AuthenticationStrategy authenticationStrategy;

    public ConnectionStartOk(int channel, FieldTable clientProperties, ShortString mechanisms, ShortString locale, LongString response, AuthenticationStrategy authenticationStrategy) {
        super(channel, (short)10, (short)11);
        this.clientProperties = clientProperties;
        this.mechanism = mechanisms;
        this.locale = locale;
        this.response = response;
        this.authenticationStrategy = authenticationStrategy;
    }

    @Override
    protected long getMethodBodySize() {
        return this.clientProperties.getSize() + this.mechanism.getSize() + this.locale.getSize() + this.response.getSize();
    }

    @Override
    protected void writeMethod(ByteBuf buf) {
        this.clientProperties.write(buf);
        this.mechanism.write(buf);
        this.locale.write(buf);
        this.response.write(buf);
    }

    @Override
    public void handle(ChannelHandlerContext ctx, AmqpConnectionHandler connectionHandler) {
        ctx.fireChannelRead(() -> {
            try {
                this.authenticationStrategy.handle(this.getChannel(), ctx, connectionHandler, this.mechanism, this.response);
            }
            catch (BrokerException e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Exception occurred while authenticating incoming connection. ", (Throwable)e);
                }
                ctx.writeAndFlush((Object)new ConnectionClose(530, ShortString.parseString((String)e.getMessage()), 10, 11));
            }
        });
    }

    public static AmqMethodBodyFactory getFactory(AuthenticationStrategy authenticationStrategy) {
        return (buf, channel, size) -> {
            FieldTable clientProperties = FieldTable.parse((ByteBuf)buf);
            ShortString mechanism = ShortString.parse((ByteBuf)buf);
            LongString response = LongString.parse((ByteBuf)buf);
            ShortString locale = ShortString.parse((ByteBuf)buf);
            return new ConnectionStartOk(channel, clientProperties, mechanism, locale, response, authenticationStrategy);
        };
    }
}

