/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.amqp.codec.frames;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.broker.amqp.codec.AmqpChannel;
import org.wso2.broker.amqp.codec.frames.AmqMethodBodyFactory;
import org.wso2.broker.amqp.codec.frames.ChannelCloseOk;
import org.wso2.broker.amqp.codec.frames.MethodFrame;
import org.wso2.broker.amqp.codec.handlers.AmqpConnectionHandler;
import org.wso2.broker.common.data.types.ShortString;

public class ChannelClose
extends MethodFrame {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChannelClose.class);
    private final int replyCode;
    private final ShortString replyText;
    private final int classId;
    private final int methodId;

    public ChannelClose(int channel, int replyCode, ShortString replyText, int classId, int methodId) {
        super(channel, (short)20, (short)40);
        this.replyCode = replyCode;
        this.replyText = replyText;
        this.classId = classId;
        this.methodId = methodId;
    }

    @Override
    protected long getMethodBodySize() {
        return 2L + this.replyText.getSize() + 2L + 2L;
    }

    @Override
    protected void writeMethod(ByteBuf buf) {
        buf.writeShort(this.replyCode);
        this.replyText.write(buf);
        buf.writeShort(this.classId);
        buf.writeShort(this.methodId);
    }

    @Override
    public void handle(ChannelHandlerContext ctx, AmqpConnectionHandler connectionHandler) {
        AmqpChannel channel = connectionHandler.getChannel(this.getChannel());
        connectionHandler.closeChannel(this.getChannel());
        ctx.fireChannelRead(() -> {
            channel.close();
            ctx.writeAndFlush((Object)new ChannelCloseOk(this.getChannel()));
        });
    }

    public static AmqMethodBodyFactory getFactory() {
        return (buf, channel, size) -> {
            int replyCode = buf.readUnsignedShort();
            ShortString replyText = ShortString.parse((ByteBuf)buf);
            int classId = buf.readUnsignedShort();
            int methodId = buf.readUnsignedShort();
            return new ChannelClose(channel, replyCode, replyText, classId, methodId);
        };
    }
}

