/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.auth;

import java.security.Security;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.broker.auth.BrokerAuthConfiguration;
import org.wso2.broker.auth.authentication.sasl.BrokerSecurityProvider;
import org.wso2.broker.auth.authentication.sasl.SaslServerBuilder;
import org.wso2.broker.auth.authentication.sasl.plain.PlainSaslServerBuilder;
import org.wso2.broker.auth.user.UserStoreManager;
import org.wso2.broker.common.BrokerConfigProvider;
import org.wso2.broker.common.StartupContext;

public class AuthManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthManager.class);
    private Map<String, SaslServerBuilder> saslMechanisms = new HashMap<String, SaslServerBuilder>();
    private BrokerAuthConfiguration brokerAuthConfiguration;
    private UserStoreManager userStoreManager;

    public AuthManager(StartupContext startupContext) throws Exception {
        BrokerConfigProvider configProvider = (BrokerConfigProvider)startupContext.getService(BrokerConfigProvider.class);
        this.brokerAuthConfiguration = (BrokerAuthConfiguration)configProvider.getConfigurationObject("wso2.broker.auth", BrokerAuthConfiguration.class);
        startupContext.registerService(AuthManager.class, (Object)this);
        this.userStoreManager = (UserStoreManager)startupContext.getService(UserStoreManager.class);
    }

    public void start() {
        if (this.brokerAuthConfiguration.getAuthentication().isEnabled()) {
            String jaasConfigPath = System.getProperty("java.auth.auth.login.config");
            BrokerAuthConfiguration.JaasConfiguration jaasConf = this.brokerAuthConfiguration.getAuthentication().getJaas();
            if (jaasConfigPath == null || jaasConfigPath.trim().isEmpty()) {
                Configuration jaasConfig = AuthManager.createJaasConfig(jaasConf.getLoginModule(), this.userStoreManager, jaasConf.getOptions());
                Configuration.setConfiguration(jaasConfig);
            }
            this.registerSaslServers();
        }
    }

    public void stop() {
        LOGGER.info("Broker auth manager service stopped.");
    }

    private void registerSaslServers() {
        PlainSaslServerBuilder plainSaslServerBuilder = new PlainSaslServerBuilder();
        this.saslMechanisms.put(plainSaslServerBuilder.getMechanismName(), plainSaslServerBuilder);
        if (Security.insertProviderAt(new BrokerSecurityProvider("AMQSASLProvider", this.saslMechanisms), 1) == -1) {
            LOGGER.info("AMQ security authentication providers are already installed.");
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("AMQ security authentication mechanisms providers are successfully registered.");
        }
    }

    private static Configuration createJaasConfig(String loginModuleClassName, UserStoreManager userStoreManager, Map<String, Object> options) {
        options.put("UserStoreManagerImpl", userStoreManager);
        final AppConfigurationEntry[] entries = new AppConfigurationEntry[]{new AppConfigurationEntry(loginModuleClassName, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
        return new Configuration(){

            @Override
            public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                return entries;
            }
        };
    }

    public SaslServer createSaslServer(String hostName, String mechanism) throws SaslException {
        SaslServerBuilder saslServerBuilder = this.saslMechanisms.get(mechanism);
        if (saslServerBuilder != null) {
            SaslServer saslServer = Sasl.createSaslServer(mechanism, "AMQP", hostName, saslServerBuilder.getProperties(), saslServerBuilder.getCallbackHandler());
            if (saslServer != null) {
                return saslServer;
            }
            throw new SaslException("Sasl server cannot be found for mechanism: " + mechanism);
        }
        throw new SaslException("Server does not support for mechanism: " + mechanism);
    }

    public boolean isAuthenticationEnabled() {
        return this.brokerAuthConfiguration.getAuthentication().isEnabled();
    }
}

