/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.auth.user.impl;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.broker.auth.BrokerAuthException;
import org.wso2.broker.auth.user.UserStoreManager;
import org.wso2.broker.auth.user.config.UserConfig;
import org.wso2.broker.auth.user.config.UsersFile;
import org.wso2.broker.auth.user.dto.User;
import org.wso2.carbon.config.ConfigProviderFactory;
import org.wso2.carbon.config.ConfigurationException;
import org.wso2.carbon.config.provider.ConfigProvider;

public class UserStoreManagerImpl
implements UserStoreManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserStoreManagerImpl.class);
    private static Map<String, User> userRegistry = new ConcurrentHashMap<String, User>();

    public UserStoreManagerImpl() throws ConfigurationException {
        String usersFilePath = System.getProperty("broker.users.config");
        Path usersYamlFile = usersFilePath == null || usersFilePath.trim().isEmpty() ? Paths.get("", "users.yaml").toAbsolutePath() : Paths.get(usersFilePath, new String[0]).toAbsolutePath();
        ConfigProvider configProvider = ConfigProviderFactory.getConfigProvider((Path)usersYamlFile, null);
        UsersFile usersFile = (UsersFile)configProvider.getConfigurationObject("wso2.broker.users", UsersFile.class);
        if (usersFile != null) {
            List<UserConfig> usersList = usersFile.getUserConfigs();
            for (UserConfig userConfig : usersList) {
                if (userConfig != null && userConfig.getUsername() != null) {
                    userRegistry.put(userConfig.getUsername(), new User(userConfig.getUsername(), userConfig.getPassword().toCharArray(), new HashSet<String>(userConfig.getRoles())));
                    continue;
                }
                LOGGER.error("User or username can not be null");
            }
        }
    }

    @Override
    public boolean authenticate(String userName, char ... credentials) throws BrokerAuthException {
        User user = userRegistry.get(userName);
        if (user == null) {
            throw new BrokerAuthException("User not found for the given username.");
        }
        if (credentials != null && Arrays.equals(credentials, user.getPassword())) {
            return true;
        }
        throw new BrokerAuthException("Password did not match with the configured user");
    }

    @Override
    public Set<String> getUserRoleList(String userName) {
        User user = userRegistry.get(userName);
        if (user != null) {
            return user.getRoles();
        }
        return null;
    }
}

