/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.auth.authentication.sasl.plain;

import com.google.common.primitives.Bytes;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.wso2.broker.auth.authentication.sasl.plain.PlainSaslCallbackHandler;

public class PlainSaslServer
implements SaslServer {
    private PlainSaslCallbackHandler callbackHandler;
    private boolean isComplete = false;
    private String authenticationId;
    private char[] password;
    static final String PLAIN_MECHANISM = "PLAIN";

    public PlainSaslServer(PlainSaslCallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    @Override
    public String getMechanismName() {
        return PLAIN_MECHANISM;
    }

    @Override
    public byte[] evaluateResponse(byte[] response) throws SaslException {
        int authzidNullPosition = Bytes.indexOf((byte[])response, (byte)0);
        if (authzidNullPosition < 0) {
            throw new SaslException("Invalid SASL/PLAIN response due to authzid null separator not found");
        }
        int authcidNullPosition = Bytes.indexOf((byte[])Arrays.copyOfRange(response, authzidNullPosition + 1, response.length), (byte)0);
        if (authcidNullPosition < 0) {
            throw new SaslException("Invalid SASL/PLAIN response due to authcid null separator not found");
        }
        this.authenticationId = new String(response, authzidNullPosition + 1, authcidNullPosition, StandardCharsets.UTF_8);
        int counter = authzidNullPosition + authcidNullPosition + 1;
        int passwordLen = response.length - counter - 1;
        this.password = new char[passwordLen];
        for (int i = 0; i < passwordLen; ++i) {
            this.password[i] = (char)response[++counter];
        }
        this.callbackHandler.setUsername(this.authenticationId);
        this.callbackHandler.setPassword(this.password);
        try {
            LoginContext loginContext = new LoginContext("BrokerSecurityConfig", this.callbackHandler);
            loginContext.login();
            this.isComplete = true;
            byte[] byArray = new byte[]{};
            return byArray;
        }
        catch (LoginException e) {
            throw new SaslException("Error while authenticating user with login module", e);
        }
        finally {
            this.clearCredentials();
        }
    }

    private void clearCredentials() {
        if (this.password != null) {
            for (int i = 0; i < this.password.length; ++i) {
                this.password[i] = 32;
            }
            this.password = null;
        }
    }

    @Override
    public boolean isComplete() {
        return this.isComplete;
    }

    @Override
    public String getAuthorizationID() {
        return this.authenticationId;
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        return new byte[0];
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        return new byte[0];
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        return null;
    }

    @Override
    public void dispose() throws SaslException {
        this.callbackHandler = null;
    }
}

