/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.auth.authentication.sasl.plain;

import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.wso2.broker.auth.authentication.sasl.plain.PlainSaslCallbackHandler;
import org.wso2.broker.auth.authentication.sasl.plain.PlainSaslServer;

public class PlainSaslServerFactory
implements SaslServerFactory {
    @Override
    public SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        if (!(cbh instanceof PlainSaslCallbackHandler)) {
            throw new SaslException("CallbackHandler must be of type of PlainSaslCallbackHandler, but received  : " + cbh.getClass());
        }
        return "PLAIN".equals(mechanism) ? new PlainSaslServer((PlainSaslCallbackHandler)cbh) : null;
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> props) {
        if (props != null && "true".equals(props.get("javax.security.sasl.policy.noplaintext"))) {
            return new String[0];
        }
        return new String[]{"PLAIN"};
    }
}

