/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.auth.authentication.jaas;

import com.sun.security.auth.UserPrincipal;
import java.io.IOException;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.wso2.broker.auth.BrokerAuthException;
import org.wso2.broker.auth.user.impl.UserStoreManagerImpl;

public class BrokerLoginModule
implements LoginModule {
    private String userName;
    private char[] password;
    private boolean success = false;
    private Subject subject;
    private CallbackHandler callbackHandler;
    private UserStoreManagerImpl userStoreManager;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.userStoreManager = (UserStoreManagerImpl)options.get("UserStoreManagerImpl");
    }

    @Override
    public boolean login() throws LoginException {
        NameCallback userNameCallback = new NameCallback("userName");
        PasswordCallback passwordCallback = new PasswordCallback("password", false);
        Callback[] callbacks = new Callback[]{userNameCallback, passwordCallback};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (UnsupportedCallbackException e) {
            throw new BrokerAuthException("Callback type does not support. ", e);
        }
        catch (IOException e) {
            throw new BrokerAuthException("Exception occurred while handling authentication data. ", e);
        }
        this.userName = userNameCallback.getName();
        this.password = passwordCallback.getPassword();
        this.success = this.validateUserPassword(this.userName, this.password);
        return this.success;
    }

    private boolean validateUserPassword(String userName, char ... password) throws BrokerAuthException {
        return userName != null && password != null && this.userStoreManager.authenticate(userName, password);
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.success) {
            UserPrincipal userPrincipal = new UserPrincipal(this.userName);
            if (!this.subject.getPrincipals().contains(userPrincipal)) {
                this.subject.getPrincipals().add(userPrincipal);
            }
            this.userName = null;
            if (this.password != null) {
                for (int i = 0; i < this.password.length; ++i) {
                    this.password[i] = 32;
                }
                this.password = null;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean abort() throws LoginException {
        this.logout();
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.success = false;
        this.userName = null;
        if (this.password != null) {
            for (int i = 0; i < this.password.length; ++i) {
                this.password[i] = 32;
            }
            this.password = null;
        }
        return true;
    }
}

