/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.client;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.MissingCommandException;
import com.beust.jcommander.ParameterException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.wso2.broker.client.cmd.MBClientCmd;
import org.wso2.broker.client.cmd.impl.InitCmd;
import org.wso2.broker.client.cmd.impl.RootCmd;
import org.wso2.broker.client.cmd.impl.create.CreateCmd;
import org.wso2.broker.client.cmd.impl.create.CreateExchangeCmd;
import org.wso2.broker.client.cmd.impl.delete.DeleteCmd;
import org.wso2.broker.client.cmd.impl.delete.DeleteExchangeCmd;
import org.wso2.broker.client.cmd.impl.list.ListCmd;
import org.wso2.broker.client.cmd.impl.list.ListExchangeCmd;
import org.wso2.broker.client.utils.BrokerClientException;
import org.wso2.broker.client.utils.Utils;

public class Main {
    private static PrintStream outStream = System.err;
    private static Map<JCommander, MBClientCmd> commandsMap = new HashMap<JCommander, MBClientCmd>();

    public static void main(String ... argv) {
        JCommander parserTreeRoot = Main.buildCommanderTree();
        try {
            Main.parseInput(parserTreeRoot, argv);
            Main.findLeafCommand(parserTreeRoot).execute();
        }
        catch (BrokerClientException e) {
            Main.printBrokerClientException(e, outStream);
        }
    }

    private static JCommander buildCommanderTree() {
        RootCmd rootCmd = new RootCmd();
        JCommander jCommanderRoot = new JCommander((Object)rootCmd);
        commandsMap.put(jCommanderRoot, rootCmd);
        Main.addChildCommand(jCommanderRoot, "init", new InitCmd());
        JCommander jCommanderList = Main.addChildCommand(jCommanderRoot, "list", new ListCmd());
        JCommander jCommanderCreate = Main.addChildCommand(jCommanderRoot, "create", new CreateCmd());
        JCommander jCommanderDelete = Main.addChildCommand(jCommanderRoot, "delete", new DeleteCmd());
        Main.addChildCommand(jCommanderList, "exchange", new ListExchangeCmd());
        Main.addChildCommand(jCommanderCreate, "exchange", new CreateExchangeCmd());
        Main.addChildCommand(jCommanderDelete, "exchange", new DeleteExchangeCmd());
        return jCommanderRoot;
    }

    private static void parseInput(JCommander jCommanderRoot, String ... argv) {
        try {
            jCommanderRoot.parse(argv);
        }
        catch (MissingCommandException e) {
            String errorMsg = "unknown command '" + e.getUnknownCommand() + "'";
            throw Utils.createUsageException(errorMsg);
        }
        catch (ParameterException e) {
            throw Utils.createUsageException(e.getMessage());
        }
    }

    private static MBClientCmd findLeafCommand(JCommander jCommander) {
        String commandText = jCommander.getParsedCommand();
        if (Objects.isNull(commandText)) {
            return commandsMap.get(jCommander);
        }
        return Main.findLeafCommand((JCommander)jCommander.getCommands().get(commandText));
    }

    private static JCommander addChildCommand(JCommander parentCommander, String commandName, MBClientCmd commandObject) {
        parentCommander.addCommand(commandName, (Object)commandObject);
        JCommander childCommander = (JCommander)parentCommander.getCommands().get(commandName);
        commandsMap.put(childCommander, commandObject);
        return childCommander;
    }

    private static void printBrokerClientException(BrokerClientException e, PrintStream outStream) {
        List<String> errorMessages = e.getMessages();
        errorMessages.forEach(outStream::println);
    }

    public static void clearCommandsMap() {
        commandsMap.clear();
    }
}

