/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.client.cmd.impl;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import org.wso2.broker.client.cmd.AbstractCmd;
import org.wso2.broker.client.resources.Configuration;
import org.wso2.broker.client.utils.Utils;

@Parameters(commandDescription="Initialize the MB CLI Client by providing HTTP connection details and user credentials")
public class InitCmd
extends AbstractCmd {
    @Parameter(names={"--host", "-H"})
    private String hostname = "127.0.0.1";
    @Parameter(names={"--port", "-P"})
    private int port = 9000;
    @Parameter(names={"--username", "-u"})
    private String username = "admin";
    @Parameter(names={"--password", "-p"}, password=true)
    private String password = "admin";

    @Override
    public void execute() {
        if (this.help) {
            this.processHelpLogs();
            return;
        }
        if (this.verbose) {
            String message = "Initialize MB CLI client with hostname: " + this.hostname + ", port: " + this.port + ", username: " + this.username;
            OUT_STREAM.println(message);
        }
        Configuration configuration = new Configuration(this.hostname, this.port, this.username, this.password);
        Utils.createConfigurationFile(configuration);
    }

    @Override
    public void printLongDesc(StringBuilder out) {
        out.append("Initialize MB admin client with connection details and user credentials.\n");
    }

    @Override
    public void printUsage(StringBuilder out) {
        out.append("Usage:\n");
        out.append("  mb init [options]*\n");
        out.append("Example:\n");
        out.append("* Enter MB REST service connection details and user credentials.\n");
        out.append("  mb init -H localhost -P 9000 -u admin -p admin123\n");
    }
}

