/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.client.cmd.impl.create;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;
import org.wso2.broker.client.cmd.impl.create.CreateCmd;
import org.wso2.broker.client.http.HttpClient;
import org.wso2.broker.client.http.HttpRequest;
import org.wso2.broker.client.http.HttpResponse;
import org.wso2.broker.client.resources.Configuration;
import org.wso2.broker.client.resources.Exchange;
import org.wso2.broker.client.utils.BrokerClientException;
import org.wso2.broker.client.utils.Utils;

@Parameters(commandDescription="Create MB exchange")
public class CreateExchangeCmd
extends CreateCmd {
    @Parameter(description="name of the exchange")
    private String exchangeName;
    @Parameter(names={"--type", "-t"}, description="type of the exchange")
    private String type = "direct";
    @Parameter(names={"--durable", "-d"}, description="durability of the exchange")
    private boolean durable = false;

    @Override
    public void execute() {
        if (this.help) {
            this.processHelpLogs();
            return;
        }
        Configuration configuration = Utils.readConfigurationFile();
        HttpClient httpClient = new HttpClient(configuration);
        String urlSuffix = "exchanges/";
        Exchange exchange = new Exchange(this.exchangeName, this.type, this.durable);
        HttpResponse response = httpClient.sendHttpRequest(new HttpRequest(urlSuffix, exchange.getAsJsonString()), "POST");
        try {
            JSONParser jsonParser = new JSONParser(-1);
            OUT_STREAM.println(jsonParser.parse(response.getPayload()).toString());
        }
        catch (ParseException e) {
            BrokerClientException parseException = new BrokerClientException();
            parseException.addMessage("error while parsing broker response for exchange creation" + e.getMessage());
            throw parseException;
        }
    }

    @Override
    public void printLongDesc(StringBuilder out) {
        out.append("Create an exchange in MB with parameters\n");
    }

    @Override
    public void printUsage(StringBuilder out) {
        out.append("Usage:\n");
        out.append("  mb create exchange [exchange-name] [options]*\n");
        out.append("Example:\n");
        out.append("* Create a durable direct Exchange in MB.\n");
        out.append("  mb create exchange myExchange -t direct -d\n");
    }
}

