/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.client.cmd.impl.delete;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;
import org.wso2.broker.client.cmd.impl.delete.DeleteCmd;
import org.wso2.broker.client.http.HttpClient;
import org.wso2.broker.client.http.HttpRequest;
import org.wso2.broker.client.http.HttpResponse;
import org.wso2.broker.client.resources.Configuration;
import org.wso2.broker.client.utils.BrokerClientException;
import org.wso2.broker.client.utils.Utils;

@Parameters(commandDescription="Delete MB exchange")
public class DeleteExchangeCmd
extends DeleteCmd {
    @Parameter(description="name of the exchange", required=true)
    private String exchangeName;
    @Parameter(names={"--unused", "-u"}, description="delete only if the exchange is not in use")
    private boolean ifUnused = false;

    @Override
    public void execute() {
        if (this.help) {
            this.processHelpLogs();
            return;
        }
        Configuration configuration = Utils.readConfigurationFile();
        HttpClient httpClient = new HttpClient(configuration);
        String urlSuffix = "exchanges/";
        HttpRequest httpRequest = new HttpRequest(urlSuffix + this.exchangeName);
        if (this.ifUnused) {
            httpRequest.setQueryParameters("?ifUnused=true");
        }
        HttpResponse response = httpClient.sendHttpRequest(httpRequest, "DELETE");
        try {
            JSONParser jsonParser = new JSONParser(-1);
            OUT_STREAM.println(jsonParser.parse(response.getPayload()).toString());
        }
        catch (ParseException e) {
            BrokerClientException parseException = new BrokerClientException();
            parseException.addMessage("error while parsing broker response for exchange deletion" + e.getMessage());
            throw parseException;
        }
    }

    @Override
    public void printLongDesc(StringBuilder out) {
        out.append("Delete an exchange in MB\n");
    }

    @Override
    public void printUsage(StringBuilder out) {
        out.append("Usage:\n");
        out.append("  mb delete exchange [exchange-name] [flag]*\n");
        out.append("Example:\n");
        out.append("* Delete exchange named 'myExchange' in MB, only if unused.\n");
        out.append("  mb delete exchange myExchange -u\n");
    }
}

