/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.client.cmd.impl.list;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;
import org.wso2.broker.client.cmd.impl.list.ListCmd;
import org.wso2.broker.client.http.HttpClient;
import org.wso2.broker.client.http.HttpRequest;
import org.wso2.broker.client.http.HttpResponse;
import org.wso2.broker.client.resources.Configuration;
import org.wso2.broker.client.utils.BrokerClientException;
import org.wso2.broker.client.utils.Utils;

@Parameters(commandDescription="List MB exchange(s)")
public class ListExchangeCmd
extends ListCmd {
    @Parameter(names={"--all", "-a"}, description="return info on all exchanges of the broker")
    private boolean all;
    @Parameter(description="name of the exchange which info needs to be retrieved")
    private String exchangeName = "";

    @Override
    public void execute() {
        if (this.help) {
            this.processHelpLogs();
            return;
        }
        Configuration configuration = Utils.readConfigurationFile();
        HttpClient httpClient = new HttpClient(configuration);
        String urlSuffix = "exchanges/";
        if (this.all) {
            this.exchangeName = "";
        }
        HttpResponse response = httpClient.sendHttpRequest(new HttpRequest(urlSuffix + this.exchangeName), "GET");
        try {
            JSONParser jsonParser = new JSONParser(-1);
            OUT_STREAM.println(jsonParser.parse(response.getPayload()).toString());
        }
        catch (ParseException e) {
            BrokerClientException parseException = new BrokerClientException();
            parseException.addMessage("error while parsing broker response " + e.getMessage());
            throw parseException;
        }
    }

    @Override
    public void printLongDesc(StringBuilder out) {
        out.append("List exchange(s) in MB\n");
    }

    @Override
    public void printUsage(StringBuilder out) {
        out.append("Usage:\n");
        out.append("  mb list exchange [exchange-name]? [flag]*\n");
        out.append("Example:\n");
        out.append("* list exchange named 'myExchange' in MB.\n");
        out.append("  mb list exchange myExchange\n");
        out.append("* list all exchanges in MB.\n");
        out.append("  mb list exchange\n");
    }
}

