/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.common.data.types;

import io.netty.buffer.ByteBuf;
import org.wso2.broker.common.data.types.EncodableData;
import org.wso2.broker.common.data.types.LongInt;
import org.wso2.broker.common.data.types.LongString;

public class FieldValue
implements EncodableData {
    private final char type;
    private final EncodableData value;

    public FieldValue(char type, EncodableData value) {
        this.type = type;
        this.value = value;
    }

    @Override
    public long getSize() {
        return 1L + this.value.getSize();
    }

    @Override
    public void write(ByteBuf buf) {
        buf.writeByte((int)this.type);
        this.value.write(buf);
    }

    public static FieldValue parse(ByteBuf buf) throws Exception {
        char type = (char)buf.readByte();
        switch (type) {
            case 'S': {
                return new FieldValue(type, LongString.parse(buf));
            }
            case 'I': {
                return new FieldValue(type, LongInt.parse(buf));
            }
        }
        throw new Exception("Invalid AMQP Field value type");
    }
}

