/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.common.data.types;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.wso2.broker.common.data.types.EncodableData;

public class LongString
implements EncodableData {
    private final long length;
    private final byte[] content;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public LongString(long length, byte[] content) {
        this.length = length;
        this.content = content;
    }

    public static LongString parseString(String data) {
        return new LongString(data.length(), data.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public long getSize() {
        return 4L + this.length;
    }

    @Override
    public void write(ByteBuf buf) {
        buf.writeInt((int)this.length);
        buf.writeBytes(this.content);
    }

    public static LongString parse(ByteBuf buf) throws Exception {
        int size = (int)buf.readUnsignedInt();
        if (size < 0) {
            throw new Exception("Invalid string length");
        }
        byte[] data = new byte[size];
        buf.readBytes(data);
        return new LongString(size, data);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj instanceof LongString && Arrays.equals(this.content, ((LongString)obj).content);
    }

    public int hashCode() {
        return Arrays.hashCode(this.content);
    }
}

