/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.common.data.types;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.wso2.broker.common.data.types.EncodableData;

public class ShortString
implements EncodableData {
    private static final int MAX_LENGTH = 255;
    private final long length;
    private final byte[] content;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public ShortString(long length, byte[] content) {
        this.length = length;
        this.content = content;
    }

    @Override
    public long getSize() {
        return this.length + 1L;
    }

    @Override
    public void write(ByteBuf buf) {
        buf.writeByte((int)this.length);
        buf.writeBytes(this.content);
    }

    public static ShortString parse(ByteBuf buf) {
        short size = buf.readUnsignedByte();
        byte[] data = new byte[size];
        buf.readBytes(data);
        return new ShortString(size, data);
    }

    public static ShortString parseString(String data) {
        return new ShortString(data.length(), data.getBytes(StandardCharsets.UTF_8));
    }

    public String toString() {
        return new String(this.content, StandardCharsets.UTF_8);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj instanceof ShortString && Arrays.equals(this.content, ((ShortString)obj).content);
    }

    public int hashCode() {
        return Arrays.hashCode(this.content);
    }
}

