/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.common.data.types;

import io.netty.buffer.ByteBuf;
import org.wso2.broker.common.data.types.EncodableData;
import org.wso2.broker.common.data.types.LongInt;
import org.wso2.broker.common.data.types.LongString;

public class FieldValue
implements EncodableData {
    private final Type type;
    private final EncodableData value;

    private FieldValue(Type type, EncodableData value) {
        this.type = type;
        this.value = value;
    }

    @Override
    public long getSize() {
        return 1L + this.value.getSize();
    }

    @Override
    public void write(ByteBuf buf) {
        buf.writeByte((int)this.type.getChar());
        this.value.write(buf);
    }

    public static FieldValue parse(ByteBuf buf) throws Exception {
        Type type = Type.valueOf((char)buf.readByte());
        switch (type) {
            case LONG_STRING: {
                return new FieldValue(Type.LONG_STRING, LongString.parse(buf));
            }
            case LONG_INT: {
                return new FieldValue(Type.LONG_INT, LongInt.parse(buf));
            }
        }
        throw new Exception("Invalid AMQP Field value type");
    }

    public Type getType() {
        return this.type;
    }

    public EncodableData getValue() {
        return this.value;
    }

    public static FieldValue parseLongInt(int value) {
        return new FieldValue(Type.LONG_INT, LongInt.parse(value));
    }

    public static FieldValue parseLongString(String value) {
        return new FieldValue(Type.LONG_STRING, LongString.parseString(value));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj instanceof FieldValue && this.type == ((FieldValue)obj).type && this.value.equals(((FieldValue)obj).value);
    }

    public int hashCode() {
        int hash = this.value.hashCode();
        return hash += this.type.getChar();
    }

    public static enum Type {
        BOOLEAN('t'),
        SHORT_SHORT_INT('b'),
        SHORT_SHORT_UINT('B'),
        SHORT_INT('U'),
        SHORT_UINT('u'),
        SHORT_STRING('s'),
        LONG_STRING('S'),
        LONG_INT('I');

        private final char type;

        private Type(char type) {
            this.type = type;
        }

        public char getChar() {
            return this.type;
        }

        public static Type valueOf(char value) throws Exception {
            switch (value) {
                case 't': {
                    return BOOLEAN;
                }
                case 'b': {
                    return SHORT_SHORT_INT;
                }
                case 'B': {
                    return SHORT_SHORT_UINT;
                }
                case 'U': {
                    return SHORT_INT;
                }
                case 'u': {
                    return SHORT_UINT;
                }
                case 'S': {
                    return LONG_STRING;
                }
                case 'I': {
                    return LONG_INT;
                }
            }
            throw new Exception("Unknown data type. Char value: '" + value + "'");
        }
    }
}

