/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.common;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastTopicMatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(FastTopicMatcher.class);
    private static final String DELIMITER = ".";
    private static final String NULL_CONSTITUENT = "%null%";
    private static final String OTHER_CONSTITUENT = "%other%";
    private static final String SINGLE_WORD_WILDCARD = "*";
    private static final String MULTIPLE_WORD_WILDCARD = "#";
    private final List<String> subscribedTopicList = new ArrayList<String>();
    private final Map<Integer, String[]> subscribedTopicConstituentsMap;
    private final List<Map<String, BitSet>> constituentTables = new ArrayList<Map<String, BitSet>>();

    public FastTopicMatcher() {
        this.subscribedTopicConstituentsMap = new HashMap<Integer, String[]>();
    }

    public void add(String topicPattern) {
        if (!this.subscribedTopicList.contains(topicPattern)) {
            this.subscribedTopicList.add(topicPattern);
            String[] constituents = topicPattern.split(Pattern.quote(DELIMITER), -1);
            this.subscribedTopicConstituentsMap.put(this.subscribedTopicList.size() - 1, constituents);
            for (int constituentIndex = 0; constituentIndex < constituents.length; ++constituentIndex) {
                Map<String, BitSet> constituentTable;
                String constituent = constituents[constituentIndex];
                if (constituentIndex < this.constituentTables.size()) {
                    constituentTable = this.constituentTables.get(constituentIndex);
                } else {
                    constituentTable = this.newTable(constituentIndex);
                    this.constituentTables.add(constituentTable);
                }
                this.addRow(constituent, constituentTable, constituentIndex);
            }
            this.addColumns(constituents);
        }
    }

    private void addColumns(String[] constituents) {
        int colNum = this.subscribedTopicList.size() - 1;
        for (int tableIndex = 0; tableIndex < this.constituentTables.size(); ++tableIndex) {
            String constituent;
            Map<String, BitSet> table = this.constituentTables.get(tableIndex);
            if (tableIndex < constituents.length) {
                constituent = constituents[tableIndex];
            } else {
                constituent = constituents[constituents.length - 1];
                if (!MULTIPLE_WORD_WILDCARD.equals(constituent)) {
                    constituent = NULL_CONSTITUENT;
                }
            }
            for (Map.Entry<String, BitSet> entry : table.entrySet()) {
                if (entry.getKey().equals(NULL_CONSTITUENT)) {
                    if (!MULTIPLE_WORD_WILDCARD.equals(constituent) && !NULL_CONSTITUENT.equals(constituent)) continue;
                    entry.getValue().set(colNum);
                    continue;
                }
                if (!entry.getKey().equals(constituent) && !MULTIPLE_WORD_WILDCARD.equals(constituent) && !SINGLE_WORD_WILDCARD.equals(constituent)) continue;
                entry.getValue().set(colNum);
            }
        }
    }

    private void addRow(String constituent, Map<String, BitSet> constituentTable, int tableIndex) {
        BitSet bitSet = MULTIPLE_WORD_WILDCARD.equals(constituent) || SINGLE_WORD_WILDCARD.equals(constituent) ? constituentTable.get(OTHER_CONSTITUENT) : constituentTable.computeIfAbsent(constituent, k -> new BitSet());
        for (int colNum = 0; colNum < this.subscribedTopicList.size(); ++colNum) {
            String columnConstituent;
            String[] subscriberConstituents = this.subscribedTopicConstituentsMap.get(colNum);
            if (tableIndex < subscriberConstituents.length) {
                columnConstituent = subscriberConstituents[tableIndex];
            } else {
                columnConstituent = subscriberConstituents[subscriberConstituents.length - 1];
                if (columnConstituent.equals(MULTIPLE_WORD_WILDCARD)) {
                    bitSet.set(colNum);
                }
            }
            if (!columnConstituent.equals(constituent) && !SINGLE_WORD_WILDCARD.equals(columnConstituent) && !MULTIPLE_WORD_WILDCARD.equals(columnConstituent)) continue;
            bitSet.set(colNum);
        }
    }

    private Map<String, BitSet> newTable(int constituentIndex) {
        HashMap<String, BitSet> constituentTable = new HashMap<String, BitSet>();
        BitSet nullBitSet = new BitSet(this.subscribedTopicList.size());
        BitSet otherBitSet = new BitSet(this.subscribedTopicList.size());
        for (int i = 0; i < this.subscribedTopicList.size(); ++i) {
            String[] constituents = this.subscribedTopicConstituentsMap.get(i);
            if (constituentIndex < constituents.length) {
                String constituent = constituents[constituentIndex];
                if (SINGLE_WORD_WILDCARD.equals(constituent)) {
                    otherBitSet.set(i);
                    continue;
                }
                if (!MULTIPLE_WORD_WILDCARD.equals(constituent)) continue;
                otherBitSet.set(i);
                nullBitSet.set(i);
                continue;
            }
            if (MULTIPLE_WORD_WILDCARD.equals(constituents[constituents.length - 1])) {
                otherBitSet.set(i);
                nullBitSet.set(i);
                continue;
            }
            nullBitSet.set(i);
        }
        constituentTable.put(NULL_CONSTITUENT, nullBitSet);
        constituentTable.put(OTHER_CONSTITUENT, otherBitSet);
        return constituentTable;
    }

    public void remove(String topicPattern) {
        int removeIndex = this.subscribedTopicList.indexOf(topicPattern);
        if (removeIndex == -1) {
            LOGGER.debug("Topic pattern {} not found.", (Object)topicPattern);
            return;
        }
        this.subscribedTopicList.remove(removeIndex);
        for (Map<String, BitSet> table : this.constituentTables) {
            for (Map.Entry<String, BitSet> entry : table.entrySet()) {
                for (int bitIndex = removeIndex; bitIndex < this.subscribedTopicList.size(); ++bitIndex) {
                    BitSet bitSet = entry.getValue();
                    bitSet.set(bitIndex, bitSet.get(bitIndex + 1));
                    String[] constituents = this.subscribedTopicConstituentsMap.remove(bitIndex + 1);
                    this.subscribedTopicConstituentsMap.put(bitIndex, constituents);
                }
            }
        }
    }

    public void matchingBindings(String topicName, Consumer<String> matchedPatternsConsumer) {
        if (topicName.isEmpty() || this.constituentTables.isEmpty() || this.subscribedTopicList.isEmpty()) {
            return;
        }
        BitSet matchedBitSet = new BitSet(this.subscribedTopicList.size());
        matchedBitSet.flip(0, this.subscribedTopicList.size());
        String[] constituents = topicName.split(Pattern.quote(DELIMITER), -1);
        int nextSetBit = -1;
        for (int tableIndex = 0; tableIndex < constituents.length; ++tableIndex) {
            BitSet bitSet;
            if (tableIndex < this.constituentTables.size()) {
                Map<String, BitSet> table = this.constituentTables.get(tableIndex);
                bitSet = table.get(constituents[tableIndex]);
                if (Objects.isNull(bitSet)) {
                    bitSet = table.get(OTHER_CONSTITUENT);
                }
            } else {
                Map<String, BitSet> lastTable = this.constituentTables.get(this.constituentTables.size() - 1);
                BitSet nullBitSet = lastTable.get(NULL_CONSTITUENT);
                matchedBitSet.and(nullBitSet);
                break;
            }
            matchedBitSet.and(bitSet);
            nextSetBit = matchedBitSet.nextSetBit(0);
            if (nextSetBit == -1) break;
        }
        if (nextSetBit > -1 && constituents.length < this.constituentTables.size()) {
            Map<String, BitSet> table = this.constituentTables.get(constituents.length);
            matchedBitSet.and(table.get(NULL_CONSTITUENT));
        }
        nextSetBit = matchedBitSet.nextSetBit(0);
        while (nextSetBit > -1) {
            String subscribedPattern = this.subscribedTopicList.get(nextSetBit);
            matchedPatternsConsumer.accept(subscribedPattern);
            nextSetBit = matchedBitSet.nextSetBit(nextSetBit + 1);
        }
    }
}

