/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.common.data.types;

import io.netty.buffer.ByteBuf;
import org.wso2.broker.common.data.types.Boolean;
import org.wso2.broker.common.data.types.EncodableData;
import org.wso2.broker.common.data.types.FieldTable;
import org.wso2.broker.common.data.types.LongInt;
import org.wso2.broker.common.data.types.LongLongInt;
import org.wso2.broker.common.data.types.LongString;
import org.wso2.broker.common.data.types.ShortShortInt;
import org.wso2.broker.common.data.types.ShortString;

public class FieldValue
implements EncodableData {
    private final Type type;
    private final EncodableData value;

    private FieldValue(Type type, EncodableData value) {
        this.type = type;
        this.value = value;
    }

    @Override
    public long getSize() {
        return 1L + this.value.getSize();
    }

    public long getValueSize() {
        return this.value.getSize();
    }

    @Override
    public void write(ByteBuf buf) {
        buf.writeByte((int)this.type.getChar());
        this.value.write(buf);
    }

    public static FieldValue parse(ByteBuf buf) throws Exception {
        Type type = Type.valueOf((char)buf.readByte());
        switch (type) {
            case BOOLEAN: {
                return FieldValue.parseBoolean(Boolean.parse(buf));
            }
            case LONG_STRING: {
                return FieldValue.parseLongString(LongString.parse(buf));
            }
            case LONG_INT: {
                return FieldValue.parseLongInt(LongInt.parse(buf));
            }
            case LONG_LONG_INT: {
                return FieldValue.parseLongLongInt(LongLongInt.parse(buf));
            }
            case SHORT_STRING: {
                return FieldValue.parseShortString(ShortString.parse(buf));
            }
            case SHORT_SHORT_INT: {
                return FieldValue.parseShortShortInt(ShortShortInt.parse(buf));
            }
            case FIELD_TABLE: {
                return FieldValue.parseFieldTable(FieldTable.parse(buf));
            }
        }
        throw new Exception("Unsupported AMQP field value type " + (Object)((Object)type));
    }

    public Type getType() {
        return this.type;
    }

    public EncodableData getValue() {
        return this.value;
    }

    public static FieldValue parseLongInt(int value) {
        return new FieldValue(Type.LONG_INT, LongInt.parse(value));
    }

    public static FieldValue parseLongInt(LongInt value) {
        return new FieldValue(Type.LONG_INT, value);
    }

    public static FieldValue parseLongString(String value) {
        return FieldValue.parseLongString(LongString.parseString(value));
    }

    public static FieldValue parseLongString(LongString value) {
        return new FieldValue(Type.LONG_STRING, value);
    }

    public static FieldValue parseShortString(String value) {
        return FieldValue.parseShortString(ShortString.parseString(value));
    }

    public static FieldValue parseShortString(ShortString value) {
        return new FieldValue(Type.SHORT_STRING, value);
    }

    public static FieldValue parseBoolean(Boolean amqpBoolean) {
        return new FieldValue(Type.BOOLEAN, amqpBoolean);
    }

    public static FieldValue parseShortShortInt(byte value) {
        return FieldValue.parseShortShortInt(ShortShortInt.parseByte(value));
    }

    public static FieldValue parseShortShortInt(ShortShortInt value) {
        return new FieldValue(Type.SHORT_SHORT_INT, value);
    }

    public static FieldValue parseLongLongInt(long value) {
        return new FieldValue(Type.LONG_LONG_INT, LongLongInt.parse(value));
    }

    public static FieldValue parseLongLongInt(LongLongInt value) {
        return new FieldValue(Type.LONG_LONG_INT, value);
    }

    public static FieldValue parseFieldTable(FieldTable fieldTable) {
        return new FieldValue(Type.FIELD_TABLE, fieldTable);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj instanceof FieldValue && this.type == ((FieldValue)obj).type && this.value.equals(((FieldValue)obj).value);
    }

    public int hashCode() {
        int hash = this.value.hashCode();
        return hash += this.type.getChar();
    }

    @Override
    public String toString() {
        return (Object)((Object)this.type) + " " + this.value.toString();
    }

    public static enum Type {
        BOOLEAN('t'),
        SHORT_SHORT_INT('b'),
        SHORT_SHORT_UINT('B'),
        SHORT_INT('U'),
        SHORT_UINT('u'),
        SHORT_STRING('s'),
        LONG_STRING('S'),
        LONG_INT('I'),
        LONG_LONG_INT('L'),
        FIELD_TABLE('F');

        private final char type;

        private Type(char type) {
            this.type = type;
        }

        public char getChar() {
            return this.type;
        }

        public static Type valueOf(char value) throws Exception {
            switch (value) {
                case 't': {
                    return BOOLEAN;
                }
                case 'b': {
                    return SHORT_SHORT_INT;
                }
                case 'B': {
                    return SHORT_SHORT_UINT;
                }
                case 'U': {
                    return SHORT_INT;
                }
                case 'u': {
                    return SHORT_UINT;
                }
                case 'S': {
                    return LONG_STRING;
                }
                case 's': {
                    return SHORT_STRING;
                }
                case 'I': {
                    return LONG_INT;
                }
                case 'L': {
                    return LONG_LONG_INT;
                }
                case 'F': {
                    return FIELD_TABLE;
                }
            }
            throw new Exception("Unknown field table data type. Char value: '" + value + "'");
        }
    }
}

