/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.coordination.rdbms;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.broker.coordination.CoordinationException;
import org.wso2.broker.coordination.node.NodeHeartbeatData;
import org.wso2.broker.coordination.rdbms.MembershipEvent;
import org.wso2.broker.coordination.rdbms.MembershipEventType;

public class RdbmsCoordinationDaoImpl {
    private static final Logger logger = LoggerFactory.getLogger(RdbmsCoordinationDaoImpl.class);
    private DataSource datasource;

    public RdbmsCoordinationDaoImpl(DataSource datasource) {
        this.datasource = datasource;
    }

    public void clearMembershipEvents(String nodeID) throws CoordinationException {
        Connection connection = null;
        PreparedStatement clearMembershipEvents = null;
        String task = "Clearing all membership events for node: " + nodeID;
        try {
            connection = this.getConnection();
            clearMembershipEvents = connection.prepareStatement("DELETE FROM MB_MEMBERSHIP WHERE NODE_ID=?");
            clearMembershipEvents.setString(1, nodeID);
            clearMembershipEvents.executeUpdate();
            connection.commit();
            this.close(clearMembershipEvents, task);
            this.close(connection, task);
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, task);
                throw new CoordinationException("Error occurred while " + task, e);
            }
            catch (Throwable throwable) {
                this.close(clearMembershipEvents, task);
                this.close(connection, task);
                throw throwable;
            }
        }
    }

    public void removeNodeHeartbeat(String nodeId) throws CoordinationException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        String task = "removing node heartbeat entry";
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("DELETE FROM MB_NODE_HEARTBEAT WHERE NODE_ID=?");
            preparedStatement.setString(1, nodeId);
            preparedStatement.executeUpdate();
            connection.commit();
            this.close(preparedStatement, task);
            this.close(connection, task);
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, task);
                throw new CoordinationException("Error occurred while " + task, e);
            }
            catch (Throwable throwable) {
                this.close(preparedStatement, task);
                this.close(connection, task);
                throw throwable;
            }
        }
    }

    public List<NodeHeartbeatData> getAllHeartBeatData() throws CoordinationException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String task = "getting heartbeat for all nodes";
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("SELECT NODE_ID,LAST_HEARTBEAT,IS_NEW_NODE FROM MB_NODE_HEARTBEAT");
            resultSet = preparedStatement.executeQuery();
            ArrayList<NodeHeartbeatData> nodeDataList = new ArrayList<NodeHeartbeatData>();
            while (resultSet.next()) {
                String nodeId = resultSet.getString(1);
                long lastHeartbeat = resultSet.getLong(2);
                boolean isNewNode = this.convertIntToBoolean(resultSet.getInt(3));
                NodeHeartbeatData heartBeatData = new NodeHeartbeatData(nodeId, lastHeartbeat, isNewNode);
                nodeDataList.add(heartBeatData);
            }
            ArrayList<NodeHeartbeatData> arrayList = nodeDataList;
            this.close(resultSet, task);
            this.close(preparedStatement, task);
            this.close(connection, task);
            return arrayList;
        }
        catch (SQLException e) {
            try {
                throw new CoordinationException("Error occurred while " + task, e);
            }
            catch (Throwable throwable) {
                this.close(resultSet, task);
                this.close(preparedStatement, task);
                this.close(connection, task);
                throw throwable;
            }
        }
    }

    public String getCoordinatorNodeId() throws CoordinationException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String task = "reading coordinator information";
        try {
            String coordinatorNodeId;
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("SELECT NODE_ID FROM MB_COORDINATOR_HEARTBEAT WHERE ANCHOR=1");
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                coordinatorNodeId = resultSet.getString(1);
                if (logger.isDebugEnabled()) {
                    logger.debug("Coordinator node ID: " + coordinatorNodeId);
                }
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("No coordinator present in the database");
                }
                coordinatorNodeId = null;
            }
            String string = coordinatorNodeId;
            this.close(resultSet, task);
            this.close(preparedStatement, task);
            this.close(connection, task);
            return string;
        }
        catch (SQLException e) {
            try {
                throw new CoordinationException("Error occurred while " + task, e);
            }
            catch (Throwable throwable) {
                this.close(resultSet, task);
                this.close(preparedStatement, task);
                this.close(connection, task);
                throw throwable;
            }
        }
    }

    public void removeCoordinator() throws CoordinationException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        String task = "removing coordinator heartbeat";
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("DELETE FROM MB_COORDINATOR_HEARTBEAT WHERE ANCHOR=1");
            preparedStatement.executeUpdate();
            connection.commit();
            this.close(preparedStatement, task);
            this.close(connection, task);
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, task);
                throw new CoordinationException("Error occurred while " + task, e);
            }
            catch (Throwable throwable) {
                this.close(preparedStatement, task);
                this.close(connection, task);
                throw throwable;
            }
        }
    }

    public boolean checkIfCoordinatorValid(int age) throws CoordinationException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String task = "reading coordinator information";
        try {
            boolean isCoordinator;
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("SELECT LAST_HEARTBEAT FROM MB_COORDINATOR_HEARTBEAT WHERE ANCHOR=1");
            resultSet = preparedStatement.executeQuery();
            long currentTimeMillis = System.currentTimeMillis();
            if (resultSet.next()) {
                long coordinatorHeartbeat = resultSet.getLong(1);
                long heartbeatAge = currentTimeMillis - coordinatorHeartbeat;
                boolean bl = isCoordinator = heartbeatAge <= (long)age;
                if (logger.isDebugEnabled()) {
                    logger.debug("isCoordinator: " + isCoordinator + ", heartbeatAge: " + age + ", coordinatorHeartBeat: " + coordinatorHeartbeat + ", currentTime: " + currentTimeMillis);
                }
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("No coordinator present in database");
                }
                isCoordinator = false;
            }
            boolean bl = isCoordinator;
            this.close(resultSet, task);
            this.close(preparedStatement, task);
            this.close(connection, task);
            return bl;
        }
        catch (SQLException e) {
            try {
                throw new CoordinationException("Error occurred while " + task, e);
            }
            catch (Throwable throwable) {
                this.close(resultSet, task);
                this.close(preparedStatement, task);
                this.close(connection, task);
                throw throwable;
            }
        }
    }

    public boolean updateNodeHeartbeat(String nodeId) throws CoordinationException {
        Connection connection = null;
        PreparedStatement preparedStatementForNodeUpdate = null;
        String task = "updating node heartbeat";
        try {
            connection = this.getConnection();
            preparedStatementForNodeUpdate = connection.prepareStatement("UPDATE MB_NODE_HEARTBEAT SET LAST_HEARTBEAT =?  WHERE NODE_ID=?");
            preparedStatementForNodeUpdate.setLong(1, System.currentTimeMillis());
            preparedStatementForNodeUpdate.setString(2, nodeId);
            int updateCount = preparedStatementForNodeUpdate.executeUpdate();
            connection.commit();
            boolean bl = updateCount != 0;
            this.close(preparedStatementForNodeUpdate, task);
            this.close(connection, task);
            return bl;
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, task);
                throw new CoordinationException("Error occurred while " + task + ". Node ID: " + nodeId, e);
            }
            catch (Throwable throwable) {
                this.close(preparedStatementForNodeUpdate, task);
                this.close(connection, task);
                throw throwable;
            }
        }
    }

    public void createNodeHeartbeatEntry(String nodeId) throws CoordinationException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        String task = "adding node row";
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("INSERT INTO MB_NODE_HEARTBEAT(NODE_ID,LAST_HEARTBEAT,IS_NEW_NODE) VALUES (?,?,1)");
            preparedStatement.setString(1, nodeId);
            preparedStatement.setLong(2, System.currentTimeMillis());
            preparedStatement.executeUpdate();
            connection.commit();
            this.close(preparedStatement, task);
            this.close(connection, task);
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, task);
                throw new CoordinationException("Error occurred while " + task + ". Node ID: " + nodeId, e);
            }
            catch (Throwable throwable) {
                this.close(preparedStatement, task);
                this.close(connection, task);
                throw throwable;
            }
        }
    }

    public boolean updateCoordinatorHeartbeat(String nodeId) throws CoordinationException {
        Connection connection = null;
        PreparedStatement preparedStatementForCoordinatorUpdate = null;
        String task = "updating coordinator heartbeat";
        try {
            connection = this.getConnection();
            preparedStatementForCoordinatorUpdate = connection.prepareStatement("UPDATE MB_COORDINATOR_HEARTBEAT SET LAST_HEARTBEAT =?  WHERE NODE_ID=? AND ANCHOR=1");
            preparedStatementForCoordinatorUpdate.setLong(1, System.currentTimeMillis());
            preparedStatementForCoordinatorUpdate.setString(2, nodeId);
            int updateCount = preparedStatementForCoordinatorUpdate.executeUpdate();
            connection.commit();
            boolean bl = updateCount != 0;
            this.close(preparedStatementForCoordinatorUpdate, task);
            this.close(connection, task);
            return bl;
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, task);
                throw new CoordinationException("Error occurred while " + task + ". instance ID: " + nodeId, e);
            }
            catch (Throwable throwable) {
                this.close(preparedStatementForCoordinatorUpdate, task);
                this.close(connection, task);
                throw throwable;
            }
        }
    }

    public void markNodeAsNotNew(String nodeId) throws CoordinationException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        String task = "marking node as not new";
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("UPDATE MB_NODE_HEARTBEAT SET IS_NEW_NODE =0  WHERE NODE_ID=?");
            preparedStatement.setString(1, nodeId);
            int updateCount = preparedStatement.executeUpdate();
            if (updateCount == 0) {
                logger.warn("No record was updated while marking node as not new");
            }
            connection.commit();
            this.close(preparedStatement, task);
            this.close(connection, task);
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, task);
                throw new CoordinationException("Error occurred while " + task, e);
            }
            catch (Throwable throwable) {
                this.close(preparedStatement, task);
                this.close(connection, task);
                throw throwable;
            }
        }
    }

    public boolean createCoordinatorEntry(String nodeId) throws CoordinationException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        String task = "adding coordinator row";
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("INSERT INTO MB_COORDINATOR_HEARTBEAT(ANCHOR,NODE_ID,LAST_HEARTBEAT) VALUES (?,?,?)");
            preparedStatement.setInt(1, 1);
            preparedStatement.setString(2, nodeId);
            preparedStatement.setLong(3, System.currentTimeMillis());
            int updateCount = preparedStatement.executeUpdate();
            connection.commit();
            boolean bl = updateCount != 0;
            this.close(preparedStatement, task);
            this.close(connection, task);
            return bl;
        }
        catch (SQLException e) {
            String errorMessage;
            block5: {
                try {
                    errorMessage = task + " instance ID: " + nodeId;
                    this.rollback(connection, task);
                    if (!this.isIntegrityConstraintViolationException(e)) break block5;
                    boolean bl = false;
                    this.close(preparedStatement, task);
                    this.close(connection, task);
                    return bl;
                }
                catch (Throwable throwable) {
                    this.close(preparedStatement, task);
                    this.close(connection, task);
                    throw throwable;
                }
            }
            throw new CoordinationException("Error occurred while " + errorMessage, e);
        }
    }

    public boolean checkIsCoordinator(String nodeId) throws CoordinationException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String task = "checking if coordinator";
        try {
            boolean isCoordinator;
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("SELECT LAST_HEARTBEAT FROM MB_COORDINATOR_HEARTBEAT WHERE NODE_ID=? AND ANCHOR=1");
            preparedStatement.setString(1, nodeId);
            resultSet = preparedStatement.executeQuery();
            boolean bl = isCoordinator = resultSet.next();
            this.close(resultSet, task);
            this.close(preparedStatement, task);
            this.close(connection, task);
            return bl;
        }
        catch (SQLException e) {
            try {
                String errorMessage = task + " instance id: " + nodeId;
                throw new CoordinationException("Error occurred while " + errorMessage, e);
            }
            catch (Throwable throwable) {
                this.close(resultSet, task);
                this.close(preparedStatement, task);
                this.close(connection, task);
                throw throwable;
            }
        }
    }

    public void storeMembershipEvent(List<String> clusterNodes, int membershipEventType, String changedMember) throws CoordinationException {
        Connection connection = null;
        PreparedStatement storeMembershipEventPreparedStatement = null;
        String task = "storing membership event: " + membershipEventType + " for member: " + changedMember;
        try {
            connection = this.getConnection();
            storeMembershipEventPreparedStatement = connection.prepareStatement("INSERT INTO MB_MEMBERSHIP (NODE_ID,CHANGE_TYPE,CHANGED_MEMBER_ID) VALUES ( ?,?,?)");
            for (String clusterNode : clusterNodes) {
                storeMembershipEventPreparedStatement.setString(1, clusterNode);
                storeMembershipEventPreparedStatement.setInt(2, membershipEventType);
                storeMembershipEventPreparedStatement.setString(3, changedMember);
                storeMembershipEventPreparedStatement.addBatch();
            }
            storeMembershipEventPreparedStatement.executeBatch();
            connection.commit();
            this.close(storeMembershipEventPreparedStatement, task);
            this.close(connection, task);
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, task);
                throw new CoordinationException(task, e);
            }
            catch (Throwable throwable) {
                this.close(storeMembershipEventPreparedStatement, task);
                this.close(connection, task);
                throw throwable;
            }
        }
    }

    public List<MembershipEvent> readMembershipEvents(String nodeID) throws CoordinationException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        PreparedStatement clearMembershipEvents = null;
        ResultSet resultSet = null;
        ArrayList<Object> membershipEvents = new ArrayList<Object>();
        String task = "retrieving membership events destined to: " + nodeID;
        try {
            Object membershipEvent;
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("SELECT EVENT_ID,CHANGE_TYPE,CHANGED_MEMBER_ID FROM MB_MEMBERSHIP WHERE NODE_ID=? ORDER BY EVENT_ID");
            preparedStatement.setString(1, nodeID);
            resultSet = preparedStatement.executeQuery();
            clearMembershipEvents = connection.prepareStatement("DELETE FROM MB_MEMBERSHIP WHERE EVENT_ID=?");
            while (resultSet.next()) {
                membershipEvent = new MembershipEvent(MembershipEventType.getTypeFromInt(resultSet.getInt("CHANGE_TYPE")), resultSet.getString("CHANGED_MEMBER_ID"));
                membershipEvents.add(membershipEvent);
                clearMembershipEvents.setLong(1, resultSet.getLong("EVENT_ID"));
                clearMembershipEvents.addBatch();
            }
            clearMembershipEvents.executeBatch();
            connection.commit();
            membershipEvent = membershipEvents;
            this.close(resultSet, task);
            this.close(preparedStatement, task);
            this.close(clearMembershipEvents, task);
            this.close(connection, task);
            return membershipEvent;
        }
        catch (SQLException e) {
            try {
                throw new CoordinationException("Error occurred while " + task, e);
            }
            catch (Throwable throwable) {
                this.close(resultSet, task);
                this.close(preparedStatement, task);
                this.close(clearMembershipEvents, task);
                this.close(connection, task);
                throw throwable;
            }
        }
    }

    protected Connection getConnection() throws SQLException {
        return this.datasource.getConnection();
    }

    protected void close(ResultSet resultSet, String task) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                logger.error("Closing result set failed after " + task, (Throwable)e);
            }
        }
    }

    protected void close(PreparedStatement preparedStatement, String task) {
        if (preparedStatement != null) {
            try {
                preparedStatement.close();
            }
            catch (SQLException e) {
                logger.error("Closing prepared statement failed after " + task, (Throwable)e);
            }
        }
    }

    protected void close(Connection connection, String task) {
        try {
            if (connection != null && !connection.isClosed()) {
                connection.close();
            }
        }
        catch (SQLException e) {
            logger.error("Failed to close connection after " + task, (Throwable)e);
        }
    }

    protected void rollback(Connection connection, String task) {
        if (connection != null) {
            try {
                connection.rollback();
            }
            catch (SQLException e) {
                logger.warn("Rollback failed on " + task, (Throwable)e);
            }
        }
    }

    private boolean convertIntToBoolean(int value) {
        return value != 0;
    }

    private boolean isIntegrityConstraintViolationException(SQLException sqlException) {
        return SQLIntegrityConstraintViolationException.class.isInstance(sqlException) || this.isIntegrityViolationSQLState(sqlException);
    }

    private boolean isIntegrityViolationSQLState(SQLException sqlException) {
        String sqlState = this.extractSqlState(sqlException);
        String sqlStateClassCode = this.determineSqlStateClassCode(sqlState);
        ArrayList<String> dataIntegrityViolationSQLStateClassCodes = new ArrayList<String>(Arrays.asList("23", "27", "44"));
        return dataIntegrityViolationSQLStateClassCodes.contains(sqlStateClassCode);
    }

    private String extractSqlState(SQLException sqlException) {
        String sqlState = sqlException.getSQLState();
        for (SQLException nextException = sqlException.getNextException(); sqlState == null && nextException != null; nextException = nextException.getNextException()) {
            sqlState = nextException.getSQLState();
        }
        return sqlState;
    }

    private String determineSqlStateClassCode(String sqlState) {
        if (sqlState == null || sqlState.length() < 2) {
            return sqlState;
        }
        return sqlState.substring(0, 2);
    }
}

