/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.metrics;

import org.wso2.broker.common.BrokerConfigProvider;
import org.wso2.broker.common.StartupContext;
import org.wso2.carbon.config.ConfigurationException;
import org.wso2.carbon.config.provider.ConfigProvider;
import org.wso2.carbon.metrics.core.MetricService;
import org.wso2.carbon.metrics.core.Metrics;

public class BrokerMetricService {
    private final Metrics metrics;

    public BrokerMetricService(StartupContext context) {
        BrokerConfigProvider configProvider = (BrokerConfigProvider)context.getService(BrokerConfigProvider.class);
        this.metrics = new Metrics((ConfigProvider)new CarbonConfigAdapter(configProvider));
        context.registerService(MetricService.class, (Object)this.metrics.getMetricService());
    }

    public void start() {
        this.metrics.activate();
    }

    public void stop() {
        this.metrics.deactivate();
    }

    private static class CarbonConfigAdapter
    implements ConfigProvider {
        private BrokerConfigProvider configProvider;

        private CarbonConfigAdapter(BrokerConfigProvider configProvider) {
            this.configProvider = configProvider;
        }

        private <T> T getConfig(String s, Class<T> aClass) throws ConfigurationException {
            try {
                return (T)this.configProvider.getConfigurationObject(s, aClass);
            }
            catch (Exception e) {
                throw new ConfigurationException("Error while reading metrics config", (Throwable)e);
            }
        }

        public <T> T getConfigurationObject(Class<T> aClass) throws ConfigurationException {
            return this.getConfig(aClass.getCanonicalName(), aClass);
        }

        public Object getConfigurationObject(String s) throws ConfigurationException {
            throw new UnsupportedOperationException();
        }

        public <T> T getConfigurationObject(String s, Class<T> aClass) throws ConfigurationException {
            return this.getConfig(s, aClass);
        }
    }
}

