/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.broker.rest.auth;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.msf4j.security.basic.AbstractBasicAuthSecurityInterceptor;

public class BasicAuthSecurityInterceptor
extends AbstractBasicAuthSecurityInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicAuthSecurityInterceptor.class);
    private AuthenticateFunction authenticateFunction;

    public BasicAuthSecurityInterceptor(AuthenticateFunction authenticateFunction) {
        this.authenticateFunction = authenticateFunction;
    }

    protected boolean authenticate(String userName, String password) {
        try {
            return userName != null && password != null && this.authenticateFunction.authenticate(userName, password.toCharArray());
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Error occurred while authenticating user", (Throwable)e);
            }
            return false;
        }
    }

    @FunctionalInterface
    public static interface AuthenticateFunction<E extends Exception> {
        public boolean authenticate(String var1, char ... var2) throws E;
    }
}

