/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ml.integration.common.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import javax.xml.xpath.XPathExpressionException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.json.JSONException;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.wso2.carbon.automation.engine.configurations.UrlGenerationUtil;
import org.wso2.carbon.automation.engine.context.AutomationContext;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.engine.context.beans.Instance;
import org.wso2.carbon.automation.engine.context.beans.Tenant;
import org.wso2.carbon.automation.engine.context.beans.User;
import org.wso2.carbon.automation.test.utils.common.HomePageGenerator;
import org.wso2.carbon.ml.integration.common.utils.MLHttpClient;
import org.wso2.carbon.ml.integration.common.utils.exception.MLHttpClientException;
import org.wso2.carbon.ml.integration.common.utils.exception.MLIntegrationBaseTestException;

public abstract class MLBaseTest {
    protected AutomationContext mlAutomationContext;
    protected Tenant tenantInfo;
    protected User userInfo;
    protected TestUserMode userMode;
    protected Instance instance;
    private MLHttpClient mlHttpclient;
    private List<Integer> datasetIds;
    private List<Integer> datasetVersionIds;
    private List<Integer> projectIds;
    private List<Integer> analysisIds;
    private List<Integer> modelIds;

    protected void init() throws MLIntegrationBaseTestException {
        try {
            this.mlAutomationContext = new AutomationContext("ML", TestUserMode.SUPER_TENANT_ADMIN);
            this.tenantInfo = this.mlAutomationContext.getContextTenant();
            this.userInfo = this.tenantInfo.getContextUser();
            this.instance = this.mlAutomationContext.getInstance();
            this.mlHttpclient = new MLHttpClient(this.instance, this.userInfo);
            this.datasetIds = new ArrayList<Integer>();
            this.projectIds = new ArrayList<Integer>();
            this.analysisIds = new ArrayList<Integer>();
            this.datasetVersionIds = new ArrayList<Integer>();
            this.modelIds = new ArrayList<Integer>();
        }
        catch (XPathExpressionException e) {
            throw new MLIntegrationBaseTestException("Failed to get the ML automation context: ", e);
        }
    }

    protected MLHttpClient getMLHttpClient() {
        return this.mlHttpclient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int createDataset(String name, String version, String dataset) throws MLHttpClientException, IOException, JSONException {
        try (CloseableHttpResponse response = null;){
            response = this.mlHttpclient.uploadDatasetFromCSV(name, version, dataset);
            AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
            int id = MLBaseTest.getId(response);
            this.datasetIds.add(id);
            int versionSetId = this.getVersionSetId(id, version);
            this.datasetVersionIds.add(versionSetId);
            int n = id;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int createDatasetFromDASTable(String name, String version, String table) throws MLHttpClientException, IOException, JSONException {
        try (CloseableHttpResponse response = null;){
            response = this.mlHttpclient.uploadDatasetFromDAS(name, version, table);
            AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
            int id = MLBaseTest.getId(response);
            this.datasetIds.add(id);
            int versionSetId = this.getVersionSetId(id, version);
            this.datasetVersionIds.add(versionSetId);
            int n = id;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int createProject(String name, String datasetName) throws MLHttpClientException, IOException {
        try (CloseableHttpResponse response = null;){
            response = this.mlHttpclient.createProject(name, datasetName);
            AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
            int id = this.mlHttpclient.getProjectId(name);
            this.projectIds.add(id);
            int n = id;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int createAnalysis(String name, int projectId) throws MLHttpClientException, IOException {
        try (CloseableHttpResponse response = null;){
            response = this.mlHttpclient.createAnalysis(name, projectId);
            AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
            int id = this.mlHttpclient.getAnalysisId(projectId, name);
            this.analysisIds.add(id);
            int n = id;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String createModel(int analysisId, int versionSetId) throws MLHttpClientException, IOException {
        try (CloseableHttpResponse response = null;){
            response = this.mlHttpclient.createModel(analysisId, versionSetId);
            AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
            String modelName = this.mlHttpclient.getModelName(response);
            int id = this.mlHttpclient.getModelId(modelName);
            this.modelIds.add(id);
            String string = modelName;
            return string;
        }
    }

    protected boolean isDatasetProcessed(int versionSetId, long timeout, int frequency) {
        try {
            return this.mlHttpclient.checkDatasetStatus(versionSetId, timeout, frequency);
        }
        catch (MLHttpClientException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    protected int getModelId(String modelName) throws MLHttpClientException {
        return this.mlHttpclient.getModelId(modelName);
    }

    protected int getVersionSetId(int datasetId, String version) throws MLHttpClientException {
        int id = this.mlHttpclient.getVersionSetIdOfDataset(datasetId, version);
        return id;
    }

    private static int getId(CloseableHttpResponse response) throws IOException, JSONException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), StandardCharsets.UTF_8));
        JSONObject responseJson = new JSONObject(bufferedReader.readLine());
        bufferedReader.close();
        response.close();
        int id = responseJson.getInt("id");
        return id;
    }

    protected String getServiceUrlHttp(String serviceName) throws MLIntegrationBaseTestException {
        try {
            String serviceUrl = this.mlAutomationContext.getContextUrls().getServiceUrl() + "/" + serviceName;
            this.validateServiceUrl(serviceUrl, this.tenantInfo);
            return serviceUrl;
        }
        catch (XPathExpressionException e) {
            throw new MLIntegrationBaseTestException("An error occured while retrieving the service (http) URL: ", e);
        }
    }

    protected String getServiceUrlHttps(String serviceName) throws MLIntegrationBaseTestException {
        try {
            String serviceUrl = this.mlAutomationContext.getContextUrls().getSecureServiceUrl() + "/" + serviceName;
            this.validateServiceUrl(serviceUrl, this.tenantInfo);
            return serviceUrl;
        }
        catch (XPathExpressionException e) {
            throw new MLIntegrationBaseTestException("An error occured while retrieving the secure service (https) URL: ", e);
        }
    }

    protected String getCarbonLoginURL() throws MLIntegrationBaseTestException {
        try {
            return HomePageGenerator.getProductHomeURL((AutomationContext)this.mlAutomationContext);
        }
        catch (XPathExpressionException e) {
            throw new MLIntegrationBaseTestException("An error occured while retrieving the Carbon login URL", e);
        }
    }

    protected String getMLUiUrl() throws MLIntegrationBaseTestException {
        try {
            String mlWebAppUrl = UrlGenerationUtil.getWebAppURL((Tenant)this.tenantInfo, (Instance)this.mlAutomationContext.getInstance()).split("\\/t\\/")[0] + "/ml/";
            return mlWebAppUrl;
        }
        catch (XPathExpressionException e) {
            throw new MLIntegrationBaseTestException("An error occured while retrieving the ML UI URL: ", e);
        }
    }

    protected void validateServiceUrl(String serviceUrl, Tenant tenant) {
        if (this.userMode != null) {
            if (this.userMode == TestUserMode.TENANT_ADMIN || this.userMode == TestUserMode.TENANT_USER) {
                Assert.assertTrue((boolean)serviceUrl.contains("/t/" + tenant.getDomain() + "/"), (String)("invalid service url for tenant. " + serviceUrl));
            } else {
                Assert.assertFalse((boolean)serviceUrl.contains("/t/"), (String)("Invalid service url:" + serviceUrl + " for tenant: " + tenant));
            }
        }
    }

    protected static String getModelStorageDirectory() {
        File modelFileStorage = new File("Models/file-storage");
        if (!modelFileStorage.exists() || !modelFileStorage.isDirectory()) {
            modelFileStorage.mkdirs();
        }
        return modelFileStorage.getAbsolutePath();
    }

    protected List<Integer> getVersionSetIds() {
        return this.datasetVersionIds;
    }

    protected void destroy() throws MLHttpClientException {
        Assert.assertNotNull(this.modelIds, (String)"Test case is not properly initialized. Call super.init()");
        Assert.assertNotNull(this.analysisIds, (String)"Test case is not properly initialized. Call super.init()");
        Assert.assertNotNull(this.projectIds, (String)"Test case is not properly initialized. Call super.init()");
        Assert.assertNotNull(this.datasetVersionIds, (String)"Test case is not properly initialized. Call super.init()");
        Assert.assertNotNull(this.datasetIds, (String)"Test case is not properly initialized. Call super.init()");
        for (Integer id : this.modelIds) {
            this.mlHttpclient.doHttpDelete("/api/models/" + id);
        }
        for (Integer id : this.analysisIds) {
            this.mlHttpclient.doHttpDelete("/api/analyses/" + id);
        }
        for (Integer id : this.projectIds) {
            this.mlHttpclient.doHttpDelete("/api/projects/" + id);
        }
        for (Integer id : this.datasetVersionIds) {
            this.mlHttpclient.doHttpDelete("/api/datasets/versions/" + id);
        }
        for (Integer id : this.datasetIds) {
            this.mlHttpclient.doHttpDelete("/api/datasets/" + id);
        }
        this.modelIds = null;
        this.analysisIds = null;
        this.projectIds = null;
        this.datasetVersionIds = null;
        this.datasetIds = null;
    }

    protected void testExportAsPMML(int modelId) throws MLHttpClientException {
        CloseableHttpResponse response = this.mlHttpclient.exportAsPMML(modelId);
        AssertJUnit.assertEquals((String)"Pmml download has failed. Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
    }

    protected void testPublishAsPMML(int modelId) throws MLHttpClientException {
        CloseableHttpResponse response = this.mlHttpclient.doHttpPost("/api/models/" + modelId + "/publish?mode=pmml", null);
        AssertJUnit.assertEquals((String)"Pmml publish has failed. Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
    }
}

