/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ml.integration.common.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.wso2.carbon.automation.engine.configurations.UrlGenerationUtil;
import org.wso2.carbon.automation.engine.context.beans.Instance;
import org.wso2.carbon.automation.engine.context.beans.User;
import org.wso2.carbon.automation.engine.frameworkutils.FrameworkPathUtil;
import org.wso2.carbon.ml.integration.common.utils.exception.MLHttpClientException;

public class MLHttpClient {
    private User userInfo;
    private Instance mlInstance;

    public MLHttpClient(Instance mlInstance, User userInfo) {
        this.mlInstance = mlInstance;
        this.userInfo = userInfo;
    }

    protected String getServerUrlHttps() {
        String protocol = "https";
        String host = UrlGenerationUtil.getWorkerHost((Instance)this.mlInstance);
        String port = null;
        boolean isNonBlockingEnabled = this.mlInstance.isNonBlockingTransportEnabled();
        port = isNonBlockingEnabled ? (String)this.mlInstance.getPorts().get("nhttps") : (String)this.mlInstance.getPorts().get("https");
        return protocol + "://" + host + ":" + port;
    }

    protected String getServerUrlHttp() {
        String protocol = "http";
        String host = UrlGenerationUtil.getWorkerHost((Instance)this.mlInstance);
        String port = null;
        boolean isNonBlockingEnabled = this.mlInstance.isNonBlockingTransportEnabled();
        port = isNonBlockingEnabled ? (String)this.mlInstance.getPorts().get("nhttp") : (String)this.mlInstance.getPorts().get("http");
        return protocol + "://" + host + ":" + port;
    }

    public CloseableHttpResponse doHttpGet(String resourcePath) throws MLHttpClientException {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpGet get = null;
        try {
            get = new HttpGet(this.getServerUrlHttps() + resourcePath);
            get.setHeader("Content-Type", "application/json");
            get.setHeader("Authorization", this.getBasicAuthKey());
            return httpClient.execute((HttpUriRequest)get);
        }
        catch (ClientProtocolException e) {
            throw new MLHttpClientException("Failed to get " + resourcePath, e);
        }
        catch (IOException e) {
            throw new MLHttpClientException("Failed to get " + resourcePath, e);
        }
    }

    public CloseableHttpResponse doHttpPost(String resourcePath, String parametersJson) throws MLHttpClientException {
        try {
            CloseableHttpClient httpClient = HttpClients.createDefault();
            HttpPost post = new HttpPost(this.getServerUrlHttps() + resourcePath);
            post.setHeader("Content-Type", "application/json");
            post.setHeader("Authorization", this.getBasicAuthKey());
            if (parametersJson != null) {
                StringEntity params = new StringEntity(parametersJson);
                post.setEntity((HttpEntity)params);
            }
            return httpClient.execute((HttpUriRequest)post);
        }
        catch (ClientProtocolException e) {
            throw new MLHttpClientException("Failed to post to " + resourcePath, e);
        }
        catch (IOException e) {
            throw new MLHttpClientException("Failed to post to " + resourcePath, e);
        }
    }

    public CloseableHttpResponse doHttpDelete(String resourcePath) throws MLHttpClientException {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        try {
            HttpDelete delete = new HttpDelete(this.getServerUrlHttps() + resourcePath);
            delete.setHeader("Content-Type", "application/json");
            delete.setHeader("Authorization", this.getBasicAuthKey());
            return httpClient.execute((HttpUriRequest)delete);
        }
        catch (ClientProtocolException e) {
            throw new MLHttpClientException("Failed to delete " + resourcePath, e);
        }
        catch (IOException e) {
            throw new MLHttpClientException("Failed to delete " + resourcePath, e);
        }
    }

    public String getBasicAuthKey() {
        String token = this.userInfo.getUserName() + ":" + this.userInfo.getPassword();
        byte[] tokenBytes = token.getBytes(StandardCharsets.UTF_8);
        String encodedToken = new String(Base64.encodeBase64((byte[])tokenBytes), StandardCharsets.UTF_8);
        return "Basic " + encodedToken;
    }

    public CloseableHttpResponse uploadDatasetFromCSV(String datasetName, String version, String resourcePath) throws MLHttpClientException {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        try {
            HttpPost httpPost = new HttpPost(this.getServerUrlHttps() + "/api/datasets/");
            httpPost.setHeader("Authorization", this.getBasicAuthKey());
            MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
            multipartEntityBuilder.addPart("description", (ContentBody)new StringBody("Sample dataset for Testing", ContentType.TEXT_PLAIN));
            multipartEntityBuilder.addPart("sourceType", (ContentBody)new StringBody("file", ContentType.TEXT_PLAIN));
            multipartEntityBuilder.addPart("destination", (ContentBody)new StringBody("file", ContentType.TEXT_PLAIN));
            multipartEntityBuilder.addPart("dataFormat", (ContentBody)new StringBody("CSV", ContentType.TEXT_PLAIN));
            multipartEntityBuilder.addPart("containsHeader", (ContentBody)new StringBody("true", ContentType.TEXT_PLAIN));
            if (datasetName != null) {
                multipartEntityBuilder.addPart("datasetName", (ContentBody)new StringBody(datasetName, ContentType.TEXT_PLAIN));
            }
            if (version != null) {
                multipartEntityBuilder.addPart("version", (ContentBody)new StringBody(version, ContentType.TEXT_PLAIN));
            }
            if (resourcePath != null) {
                File file = new File(this.getResourceAbsolutePath(resourcePath));
                multipartEntityBuilder.addBinaryBody("file", file, ContentType.APPLICATION_OCTET_STREAM, "IndiansDiabetes.csv");
            }
            httpPost.setEntity(multipartEntityBuilder.build());
            return httpClient.execute((HttpUriRequest)httpPost);
        }
        catch (Exception e) {
            throw new MLHttpClientException("Failed to upload dataset from csv " + resourcePath, e);
        }
    }

    public CloseableHttpResponse uploadDatasetFromDAS(String datasetName, String version, String tableName) throws MLHttpClientException {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        try {
            HttpPost httpPost = new HttpPost(this.getServerUrlHttps() + "/api/datasets/");
            httpPost.setHeader("Authorization", this.getBasicAuthKey());
            MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
            multipartEntityBuilder.addPart("description", (ContentBody)new StringBody("Sample dataset for Testing", ContentType.TEXT_PLAIN));
            multipartEntityBuilder.addPart("sourceType", (ContentBody)new StringBody("das", ContentType.TEXT_PLAIN));
            multipartEntityBuilder.addPart("destination", (ContentBody)new StringBody("file", ContentType.TEXT_PLAIN));
            multipartEntityBuilder.addPart("dataFormat", (ContentBody)new StringBody("CSV", ContentType.TEXT_PLAIN));
            multipartEntityBuilder.addPart("sourcePath", (ContentBody)new StringBody(tableName, ContentType.TEXT_PLAIN));
            if (datasetName != null) {
                multipartEntityBuilder.addPart("datasetName", (ContentBody)new StringBody(datasetName, ContentType.TEXT_PLAIN));
            }
            if (version != null) {
                multipartEntityBuilder.addPart("version", (ContentBody)new StringBody(version, ContentType.TEXT_PLAIN));
            }
            multipartEntityBuilder.addBinaryBody("file", new byte[0], ContentType.APPLICATION_OCTET_STREAM, "IndiansDiabetes.csv");
            httpPost.setEntity(multipartEntityBuilder.build());
            return httpClient.execute((HttpUriRequest)httpPost);
        }
        catch (Exception e) {
            throw new MLHttpClientException("Failed to upload dataset from DAS " + tableName, e);
        }
    }

    public CloseableHttpResponse predictFromCSV(long modelId, String resourcePath) throws MLHttpClientException {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        try {
            HttpPost httpPost = new HttpPost(this.getServerUrlHttps() + "/api/models/predict");
            httpPost.setHeader("Authorization", this.getBasicAuthKey());
            MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
            multipartEntityBuilder.addPart("modelId", (ContentBody)new StringBody(modelId + "", ContentType.TEXT_PLAIN));
            multipartEntityBuilder.addPart("dataFormat", (ContentBody)new StringBody("CSV", ContentType.TEXT_PLAIN));
            if (resourcePath != null) {
                File file = new File(this.getResourceAbsolutePath(resourcePath));
                multipartEntityBuilder.addBinaryBody("file", file, ContentType.APPLICATION_OCTET_STREAM, "IndiansDiabetesPredict.csv");
            }
            httpPost.setEntity(multipartEntityBuilder.build());
            return httpClient.execute((HttpUriRequest)httpPost);
        }
        catch (Exception e) {
            throw new MLHttpClientException("Failed to predict from csv " + resourcePath, e);
        }
    }

    public CloseableHttpResponse createProject(String ProjectName, String datasetName) throws MLHttpClientException {
        try {
            String payload = ProjectName == null ? "{\"description\" : \"Test Project\",\"datasetName\": \"" + datasetName + "\"}" : (datasetName == null ? "{\"name\" : \"" + ProjectName + "\",\"description\" : \"Test Project\"}" : "{\"name\" : \"" + ProjectName + "\",\"description\" : \"Test Project\",\"datasetName\": \"" + datasetName + "\"}");
            return this.doHttpPost("/api/projects", payload);
        }
        catch (MLHttpClientException e) {
            throw new MLHttpClientException("Failed to create project " + ProjectName, e);
        }
    }

    public CloseableHttpResponse createAnalysis(String AnalysisName, int ProjectId) throws MLHttpClientException {
        try {
            String payload = AnalysisName == null ? "{\"comments\":\"Test Analysis\",\"projectId\":" + ProjectId + "}" : (ProjectId == -1 ? "{\"name\":\"" + AnalysisName + "\",\"comments\":\"Test Analysis\"}" : "{\"name\":\"" + AnalysisName + "\",\"comments\":\"Test Analysis\",\"projectId\":" + ProjectId + "}");
            return this.doHttpPost("/api/analyses", payload);
        }
        catch (MLHttpClientException e) {
            throw new MLHttpClientException("Failed to create analysis: " + AnalysisName + " in project: " + ProjectId, e);
        }
    }

    public CloseableHttpResponse setFeatureDefaults(int analysisId) throws MLHttpClientException {
        String payload = "{\"include\" : true,\"imputeOption\": \"DISCARD\"}";
        try {
            return this.doHttpPost("/api/analyses/" + analysisId + "/features/defaults", payload);
        }
        catch (MLHttpClientException e) {
            throw new MLHttpClientException("Failed to set Feature defaults to analysis: " + analysisId, e);
        }
    }

    public boolean checkDatasetStatus(int versionSetId, long timeout, int frequency) throws MLHttpClientException, IOException {
        boolean status = false;
        int totalTime = 0;
        while (!status && timeout >= (long)totalTime) {
            CloseableHttpResponse response = this.doHttpGet("/api/datasets/versions/" + versionSetId + "/sample");
            int statusCode = response.getStatusLine().getStatusCode();
            response.close();
            status = statusCode != 404;
            try {
                Thread.sleep(frequency);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            totalTime += frequency;
        }
        return status;
    }

    public CloseableHttpResponse setFeatureCustomized(int analysisId, String customizedFeatures) throws MLHttpClientException {
        try {
            return this.doHttpPost("/api/analyses/" + analysisId + "/features", customizedFeatures);
        }
        catch (MLHttpClientException e) {
            throw new MLHttpClientException("Failed to set customized features to analysis: " + analysisId, e);
        }
    }

    public CloseableHttpResponse setModelConfiguration(int analysisId, Map<String, String> configurations) throws MLHttpClientException {
        try {
            String payload = "[";
            for (Map.Entry<String, String> property : configurations.entrySet()) {
                payload = payload + "{\"key\":\"" + property.getKey() + "\",\"value\":\"" + property.getValue() + "\"},";
            }
            payload = payload.substring(0, payload.length() - 1) + "]";
            return this.doHttpPost("/api/analyses/" + analysisId + "/configurations", payload);
        }
        catch (MLHttpClientException e) {
            throw new MLHttpClientException("Failed to set model configurations to analysis: " + analysisId, e);
        }
    }

    public int getProjectId(String projectName) throws MLHttpClientException {
        try {
            CloseableHttpResponse response = this.doHttpGet("/api/projects/" + projectName);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), StandardCharsets.UTF_8));
            JSONObject responseJson = new JSONObject(bufferedReader.readLine());
            bufferedReader.close();
            response.close();
            return responseJson.getInt("id");
        }
        catch (Exception e) {
            throw new MLHttpClientException("Failed to get ID of project: " + projectName, e);
        }
    }

    public int getAnalysisId(int projectId, String analysisName) throws MLHttpClientException {
        try {
            CloseableHttpResponse response = this.doHttpGet("/api/projects/" + projectId + "/analyses/" + analysisName);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), StandardCharsets.UTF_8));
            JSONObject responseJson = new JSONObject(bufferedReader.readLine());
            bufferedReader.close();
            response.close();
            return responseJson.getInt("id");
        }
        catch (Exception e) {
            throw new MLHttpClientException("Failed to get ID of analysis: " + analysisName, e);
        }
    }

    public int getAVersionSetIdOfDataset(int datasetId) throws MLHttpClientException {
        try {
            CloseableHttpResponse response = this.doHttpGet("/api/datasets/" + datasetId + "/versions");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), StandardCharsets.UTF_8));
            JSONArray responseJson = new JSONArray(bufferedReader.readLine());
            JSONObject datsetVersionJson = (JSONObject)responseJson.get(0);
            bufferedReader.close();
            response.close();
            return datsetVersionJson.getInt("id");
        }
        catch (Exception e) {
            throw new MLHttpClientException("Failed to get a version set ID of dataset: " + datasetId, e);
        }
    }

    public int getVersionSetIdOfDataset(int datasetId, String version) throws MLHttpClientException {
        try {
            CloseableHttpResponse response = this.doHttpGet("/api/datasets/" + datasetId + "/versions/" + version);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), StandardCharsets.UTF_8));
            String line = bufferedReader.readLine();
            JSONObject responseJson = new JSONObject(line);
            bufferedReader.close();
            response.close();
            return responseJson.getInt("id");
        }
        catch (Exception e) {
            throw new MLHttpClientException("Failed to get a version set ID of dataset: " + datasetId, e);
        }
    }

    public CloseableHttpResponse createModel(int analysisId, int versionSetId) throws MLHttpClientException {
        try {
            String payload = "{\"analysisId\" :" + analysisId + ",\"versionSetId\" :" + versionSetId + "}";
            return this.doHttpPost("/api/models/", payload);
        }
        catch (MLHttpClientException e) {
            throw new MLHttpClientException("Failed to create a model in analysis: " + analysisId + "using versionset: " + versionSetId, e);
        }
    }

    public String getResponseAsString(CloseableHttpResponse response) throws MLHttpClientException {
        if (response == null || response.getEntity() == null) {
            return null;
        }
        String reply = null;
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), StandardCharsets.UTF_8));
            String line = bufferedReader.readLine();
            try {
                JSONObject responseJson = new JSONObject(line);
                reply = responseJson.toString();
            }
            catch (JSONException e) {
                JSONArray responseArray = new JSONArray(line);
                reply = responseArray.toString();
            }
            bufferedReader.close();
            response.close();
            return reply;
        }
        catch (Exception e) {
            throw new MLHttpClientException("Failed to extract the response body.", e);
        }
    }

    public JSONObject getResponseAsJSONObject(CloseableHttpResponse response) throws MLHttpClientException {
        if (response == null || response.getEntity() == null) {
            return null;
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), StandardCharsets.UTF_8));
            JSONObject responseJson = new JSONObject(bufferedReader.readLine());
            bufferedReader.close();
            response.close();
            return responseJson;
        }
        catch (Exception e) {
            throw new MLHttpClientException("Failed to extract the response body.", e);
        }
    }

    public int getModelId(String modelName) throws MLHttpClientException {
        try {
            CloseableHttpResponse response = this.doHttpGet("/api/models/" + modelName);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), StandardCharsets.UTF_8));
            JSONObject responseJson = new JSONObject(bufferedReader.readLine());
            bufferedReader.close();
            response.close();
            return responseJson.getInt("id");
        }
        catch (Exception e) {
            throw new MLHttpClientException("Failed to get a version set ID of model: " + modelName, e);
        }
    }

    public CloseableHttpResponse createFileModelStorage(int modelId, String folderName) throws MLHttpClientException {
        String payload = "{\"type\":\"file\",\"location\":\"" + folderName + "\"}";
        try {
            return this.doHttpPost("/api/models/" + modelId + "/storages", payload);
        }
        catch (MLHttpClientException e) {
            throw new MLHttpClientException("Failed to file storage for model: " + modelId, e);
        }
    }

    public String getResourceAbsolutePath(String resourceRelativePath) {
        return FrameworkPathUtil.getSystemResourceLocation() + resourceRelativePath;
    }

    public String getModelName(CloseableHttpResponse response) throws MLHttpClientException {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), StandardCharsets.UTF_8));
            JSONObject responseJson = new JSONObject(bufferedReader.readLine());
            bufferedReader.close();
            response.close();
            return responseJson.getString("name");
        }
        catch (Exception e) {
            throw new MLHttpClientException("Failed to get the name of model", e);
        }
    }

    public CloseableHttpResponse exportAsPMML(int modelId) throws MLHttpClientException {
        try {
            CloseableHttpResponse response = this.doHttpGet("/api/models/" + modelId + "/export?mode=pmml");
            return response;
        }
        catch (MLHttpClientException e) {
            throw new MLHttpClientException("Failed to download model as PMML for model [id] " + modelId, e);
        }
    }
}

