/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ml.analysis.test;

import java.io.IOException;
import javax.ws.rs.core.Response;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.carbon.ml.integration.common.utils.MLBaseTest;
import org.wso2.carbon.ml.integration.common.utils.MLHttpClient;
import org.wso2.carbon.ml.integration.common.utils.exception.MLHttpClientException;

@Test(groups={"deleteAnalyses"})
public class DeleteAnalysesTestCase
extends MLBaseTest {
    private MLHttpClient mlHttpclient;
    private int projectId;
    private int analysisId;

    @BeforeClass(alwaysRun=true)
    public void initTest() throws Exception {
        super.init();
        this.mlHttpclient = this.getMLHttpClient();
        this.createDataset("Diabetes", "1.0", "artifacts/ML/data/pIndiansDiabetes.csv");
        this.isDatasetProcessed((Integer)this.getVersionSetIds().get(0), 20000L, 1000);
        this.projectId = this.createProject("Diabetes_Project", "Diabetes");
        this.analysisId = this.createAnalysis("Dummy_Analysis", this.projectId);
    }

    @Test(description="Delete an analysis")
    public void testDeleteAnalysis() throws MLHttpClientException, IOException {
        CloseableHttpResponse response = this.mlHttpclient.doHttpDelete("/api/analyses/" + this.analysisId);
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        response.close();
    }

    @Test(description="Delete a non-existing analysis")
    public void testDeleteNonExistingAnalysis() throws MLHttpClientException, IOException {
        CloseableHttpResponse response = this.mlHttpclient.doHttpDelete("/api/analyses/100");
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        response.close();
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() throws MLHttpClientException {
        super.destroy();
    }
}

