/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ml.lifecycle.test;

import java.io.IOException;
import javax.ws.rs.core.Response;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.json.JSONArray;
import org.json.JSONException;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.carbon.ml.MLTestUtils;
import org.wso2.carbon.ml.integration.common.utils.MLBaseTest;
import org.wso2.carbon.ml.integration.common.utils.MLHttpClient;
import org.wso2.carbon.ml.integration.common.utils.exception.MLHttpClientException;
import org.wso2.carbon.ml.integration.common.utils.exception.MLIntegrationBaseTestException;

@Test(groups={"diabetesDatasetAnomalyDetection"})
public class Dataset10AnomalyDetectionTestCase
extends MLBaseTest {
    private MLHttpClient mlHttpclient;
    private static String modelName;
    private static int modelId;
    private CloseableHttpResponse response;
    private int versionSetId;
    private int projectId;

    @BeforeClass(alwaysRun=true)
    public void initTest() throws MLIntegrationBaseTestException, MLHttpClientException, IOException, JSONException {
        super.init();
        this.mlHttpclient = this.getMLHttpClient();
        String version = "1.0";
        int datasetId = this.createDataset("Diabetes_Anomaly", version, "artifacts/ML/data/pIndiansDiabetes.csv");
        this.versionSetId = this.getVersionSetId(datasetId, version);
        this.isDatasetProcessed(this.versionSetId, 20000L, 1000);
        this.projectId = this.createProject("Diabetes_Anomaly_Detection_Project", "Diabetes_Anomaly");
    }

    private void testPredictDiabetes(String algorithmName) throws MLHttpClientException, JSONException {
        String payload = "";
        if (algorithmName.equals("K_MEANS_ANOMALY_DETECTION_WITH_UNLABELED_DATA")) {
            payload = "[[1,89,66,23,94,28.1,0.167,21,0],[50,166,72,19,500,25.8,0.587,510,1]]";
        } else if (algorithmName.equals("K_MEANS_ANOMALY_DETECTION_WITH_LABELED_DATA")) {
            payload = "[[1,89,66,23,94,28.1,0.167,21],[50,166,72,19,500,25.8,0.587,510]]";
        }
        this.response = this.mlHttpclient.doHttpPost("/api/models/" + modelId + "/predict?percentile=95", payload);
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)this.response.getStatusLine().getStatusCode());
        String reply = this.mlHttpclient.getResponseAsString(this.response);
        JSONArray predictions = new JSONArray(reply);
        AssertJUnit.assertEquals((int)2, (int)predictions.length());
        AssertJUnit.assertEquals((String)"normal", (String)predictions.getString(0));
        AssertJUnit.assertEquals((String)"anomaly", (String)predictions.getString(1));
    }

    private void buildModelWithLearningAlgorithm(String algorithmName, String algorithmType) throws MLHttpClientException, IOException, JSONException, InterruptedException {
        if (algorithmName.equals("K_MEANS_ANOMALY_DETECTION_WITH_UNLABELED_DATA")) {
            modelName = MLTestUtils.createModelWithConfigurations(algorithmName, algorithmType, "", "1.0", "", "normal", "anomaly", "false", this.projectId, this.versionSetId, this.mlHttpclient);
        } else if (algorithmName.equals("K_MEANS_ANOMALY_DETECTION_WITH_LABELED_DATA")) {
            modelName = MLTestUtils.createModelWithConfigurations(algorithmName, algorithmType, "Class", "0.7", "0", "normal", "anomaly", "false", this.projectId, this.versionSetId, this.mlHttpclient);
        }
        modelId = this.mlHttpclient.getModelId(modelName);
        this.response = this.mlHttpclient.doHttpPost("/api/models/" + modelId, null);
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)this.response.getStatusLine().getStatusCode());
        this.response.close();
        boolean status = MLTestUtils.checkModelStatusCompleted(modelName, this.mlHttpclient, 20000L, 1000);
        AssertJUnit.assertEquals((String)"Model building did not complete successfully", (boolean)true, (boolean)status);
    }

    @Test(description="Build a Unlabeled anomaly detection model and predict for Diabetes dataset", groups={"createUnlabeledAnomalyDetectionDiabetes"})
    public void testBuildUnlabeledAnomalyDetectionModel() throws MLHttpClientException, IOException, JSONException, InterruptedException {
        this.buildModelWithLearningAlgorithm("K_MEANS_ANOMALY_DETECTION_WITH_UNLABELED_DATA", "Anomaly_Detection");
        this.testPredictDiabetes("K_MEANS_ANOMALY_DETECTION_WITH_UNLABELED_DATA");
    }

    @Test(description="Build a Labeled anomaly detection model and predict for Diabetes dataset", groups={"createLabeledAnomalyDetectionDiabetes"}, dependsOnGroups={"createUnlabeledAnomalyDetectionDiabetes"})
    public void testBuildLabeledAnomalyDetectionModel() throws MLHttpClientException, IOException, JSONException, InterruptedException {
        this.buildModelWithLearningAlgorithm("K_MEANS_ANOMALY_DETECTION_WITH_LABELED_DATA", "Anomaly_Detection");
        this.testPredictDiabetes("K_MEANS_ANOMALY_DETECTION_WITH_LABELED_DATA");
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() throws InterruptedException, MLHttpClientException {
        super.destroy();
    }
}

