/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ml.project.test;

import java.io.IOException;
import javax.ws.rs.core.Response;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.json.JSONException;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.carbon.ml.integration.common.utils.MLBaseTest;
import org.wso2.carbon.ml.integration.common.utils.MLHttpClient;
import org.wso2.carbon.ml.integration.common.utils.exception.MLHttpClientException;
import org.wso2.carbon.ml.integration.common.utils.exception.MLIntegrationBaseTestException;

@Test(groups={"ml-projects"})
public class MLProjectsTestCase
extends MLBaseTest {
    private MLHttpClient mlHttpclient;

    @BeforeClass(alwaysRun=true)
    public void initTest() throws MLIntegrationBaseTestException, MLHttpClientException, IOException, JSONException {
        super.init();
        this.mlHttpclient = this.getMLHttpClient();
        this.createDataset("Diabetes", "1.0", "artifacts/ML/data/pIndiansDiabetes.csv");
        this.isDatasetProcessed((Integer)this.getVersionSetIds().get(0), 20000L, 1000);
    }

    @Test(priority=1, description="Create a project")
    public void testCreateProject() throws MLHttpClientException, IOException {
        CloseableHttpResponse response = this.mlHttpclient.createProject("Diabetes_Project", "Diabetes");
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        response.close();
    }

    @Test(priority=2, description="Create a project with duplicate Name")
    public void testCreateProjectWithDuplicateName() throws MLHttpClientException, IOException {
        CloseableHttpResponse response = this.mlHttpclient.createProject("Diabetes_Project", "Diabetes");
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        response.close();
    }

    @Test(priority=2, description="Create a project without name")
    public void testCreateProjectWithoutName() throws MLHttpClientException, IOException {
        CloseableHttpResponse response = this.mlHttpclient.createProject(null, "Diabetes");
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.BAD_REQUEST.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        response.close();
    }

    @Test(priority=2, description="Create a project without a dataset")
    public void testCreateProjectWithoutDataset() throws MLHttpClientException, IOException {
        CloseableHttpResponse response = this.mlHttpclient.createProject("TestProjectForCreatProjectTestCase-2", null);
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.BAD_REQUEST.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        response.close();
    }

    @Test(priority=5, description="Retrieve all projects")
    public void testGetAllProjects() throws MLHttpClientException, IOException {
        CloseableHttpResponse response = this.mlHttpclient.doHttpGet("/api/projects");
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        response.close();
    }

    @Test(priority=5, description="Retrieve all projects with analyses")
    public void testGetAllProjectsWithAnalyses() throws MLHttpClientException, IOException {
        CloseableHttpResponse response = this.mlHttpclient.doHttpGet("/api/projects/analyses");
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        response.close();
    }

    @Test(priority=5, description="Retrieve projects of a dataset with analyses")
    public void testGetProjectsOfDatasetWithAnalyses() throws MLHttpClientException, IOException {
        CloseableHttpResponse response = this.mlHttpclient.doHttpGet("/api/projects/analyses?datasetName=Diabetes");
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        response.close();
    }

    @Test(priority=6, description="Retrieve a project")
    public void testGetProject() throws MLHttpClientException, IOException {
        CloseableHttpResponse response = this.mlHttpclient.doHttpGet("/api/projects/Diabetes_Project");
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        response.close();
    }

    @Test(priority=6, description="Retrieve a non-existing project")
    public void testGetNonExistingProject() throws MLHttpClientException, IOException {
        CloseableHttpResponse response = this.mlHttpclient.doHttpGet("/api/projects/NON_EXISTING_PROJECT");
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.NOT_FOUND.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        response.close();
    }

    @Test(priority=7, description="Delete an exsisting project")
    public void testDeleteProject() throws MLHttpClientException, IOException {
        int projectId = this.mlHttpclient.getProjectId("Diabetes_Project");
        CloseableHttpResponse response = this.mlHttpclient.doHttpDelete("/api/projects/" + projectId);
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        response.close();
    }

    @Test(priority=8, description="Delete an exsisting project")
    public void testDeleteNonExistingProject() throws MLHttpClientException, IOException {
        CloseableHttpResponse response = this.mlHttpclient.doHttpDelete("/api/projects/999");
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        response.close();
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() throws MLHttpClientException {
        super.destroy();
    }
}

