/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ml.analysis.test;

import java.io.IOException;
import javax.ws.rs.core.Response;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.carbon.ml.integration.common.utils.MLBaseTest;
import org.wso2.carbon.ml.integration.common.utils.MLHttpClient;
import org.wso2.carbon.ml.integration.common.utils.exception.MLHttpClientException;

@Test(groups={"addFeatures"})
public class FeatureProcessingTestCase
extends MLBaseTest {
    private MLHttpClient mlHttpclient;
    private int projectId;
    private int analysisId;

    @BeforeClass(alwaysRun=true)
    public void initTest() throws Exception {
        super.init();
        this.mlHttpclient = this.getMLHttpClient();
        this.createDataset("Diabetes", "1.0", "artifacts/ML/data/pIndiansDiabetes.csv");
        this.isDatasetProcessed((Integer)this.getVersionSetIds().get(0), 20000L, 1000);
        this.projectId = this.createProject("Diabetes_Project", "Diabetes");
        this.analysisId = this.createAnalysis("Dummy_Analysis", this.projectId);
    }

    @Test(priority=1, description="Add default values to customized features")
    public void testAddDefaultsToCustomizedFeatures() throws MLHttpClientException, IOException {
        CloseableHttpResponse response = this.mlHttpclient.setFeatureDefaults(this.analysisId);
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        response.close();
    }

    @Test(priority=2, description="Add customized features")
    public void testAddCustomizedFeatures() throws MLHttpClientException, IOException {
        String payload = "[{\"type\" :\"NUMERICAL\",\"include\" : false,\"imputeOption\":\"DISCARD\",\"name\":\"Age\"}]";
        CloseableHttpResponse response = this.mlHttpclient.doHttpPost("/api/analyses/" + this.analysisId + "/features", payload);
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        response.close();
    }

    @Test(priority=3, description="Get all features")
    public void testGetAllFeatures() throws MLHttpClientException, IOException {
        CloseableHttpResponse response = this.mlHttpclient.doHttpGet("/api/analyses/" + this.analysisId + "/features");
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        response.close();
    }

    @Test(priority=3, description="Get all summarized features")
    public void testGetSummarizedFeatures() throws MLHttpClientException, IOException {
        CloseableHttpResponse response = this.mlHttpclient.doHttpGet("/api/analyses/" + this.analysisId + "/summarizedFeatures");
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        response.close();
    }

    @Test(priority=3, description="Get all filtered features")
    public void testGetFilteredFeatures() throws MLHttpClientException, IOException {
        CloseableHttpResponse response = this.mlHttpclient.doHttpGet("/api/analyses/" + this.analysisId + "/filteredFeatures?featureType=CATEGORICAL");
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        response.close();
    }

    @Test(priority=4, description="Get summary stats - without providing a feature")
    public void testGetSummaryStatsWithoutFeature() throws MLHttpClientException, IOException {
        CloseableHttpResponse response = this.mlHttpclient.doHttpGet("/api/analyses/" + this.analysisId + "/stats");
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.NOT_FOUND.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        response.close();
    }

    @Test(priority=4, description="Get summary stats - with feature")
    public void testGetSummaryStatsWithFeature() throws MLHttpClientException, IOException {
        CloseableHttpResponse response = this.mlHttpclient.doHttpGet("/api/analyses/" + this.analysisId + "/stats?feature=Class");
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        response.close();
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() throws MLHttpClientException {
        super.destroy();
    }
}

