/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ml.model.test;

import java.io.IOException;
import javax.ws.rs.core.Response;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.carbon.ml.integration.common.utils.MLBaseTest;
import org.wso2.carbon.ml.integration.common.utils.MLHttpClient;
import org.wso2.carbon.ml.integration.common.utils.MLIntegrationTestConstants;
import org.wso2.carbon.ml.integration.common.utils.exception.MLHttpClientException;

@Test(groups={"createModels"})
public class CreateModelTestCase
extends MLBaseTest {
    private MLHttpClient mlHttpclient;
    private int projectId;
    private int analysisId;
    private int versionSetId;

    @BeforeClass(alwaysRun=true)
    public void initTest() throws Exception {
        super.init();
        this.mlHttpclient = this.getMLHttpClient();
        String version = "1.0";
        int datasetId = this.createDataset("Diabetes", version, "artifacts/ML/data/pIndiansDiabetes.csv");
        this.versionSetId = this.getVersionSetId(datasetId, version);
        this.isDatasetProcessed(this.versionSetId, 20000L, 1000);
        this.projectId = this.createProject("Diabetes_Project", "Diabetes");
        this.analysisId = this.createAnalysis("Dummy_Analysis", this.projectId);
    }

    @Test(priority=1, description="Create a Model")
    public void testCreateModel() throws MLHttpClientException, IOException {
        CloseableHttpResponse response = this.mlHttpclient.createModel(this.analysisId, this.versionSetId);
        MLIntegrationTestConstants.MODEL_NAME = this.mlHttpclient.getModelName(response);
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        response.close();
    }

    @Test(priority=1, description="Create a Model with an invalid analysis")
    public void testCreateModelWithInvalidAnalysis() throws MLHttpClientException, IOException {
        CloseableHttpResponse response = this.mlHttpclient.createModel(999, this.versionSetId);
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        response.close();
    }

    @Test(priority=1, description="Create a Model with an invalid versionset")
    public void testCreateModelWithInvalidVersionset() throws MLHttpClientException, IOException {
        CloseableHttpResponse response = this.mlHttpclient.createModel(this.analysisId, 999);
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        response.close();
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() throws MLHttpClientException {
        super.destroy();
    }
}

