/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ml;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.wso2.carbon.ml.integration.common.utils.MLBaseTest;
import org.wso2.carbon.ml.integration.common.utils.MLHttpClient;
import org.wso2.carbon.ml.integration.common.utils.exception.MLHttpClientException;

public class MLTestUtils
extends MLBaseTest {
    private static String analysisName;
    private static String modelName;
    private static int analysisId;
    private static int modelId;

    public static int getId(CloseableHttpResponse response) throws IOException, JSONException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
        JSONObject responseJson = new JSONObject(bufferedReader.readLine());
        bufferedReader.close();
        response.close();
        int id = responseJson.getInt("id");
        return id;
    }

    public static String getJsonArrayAsString(CloseableHttpResponse response) throws IOException, JSONException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
        JSONArray responseJson = new JSONArray(bufferedReader.readLine());
        bufferedReader.close();
        response.close();
        return responseJson.toString();
    }

    public static boolean checkModelStatusCompleted(String modelName, MLHttpClient mlHttpclient, long timeout, int frequency) throws MLHttpClientException, JSONException, IOException {
        boolean status = false;
        int totalTime = 0;
        while (!status && timeout >= (long)totalTime) {
            CloseableHttpResponse response = mlHttpclient.doHttpGet("/api/models/" + modelName);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            JSONObject responseJson = new JSONObject(bufferedReader.readLine());
            bufferedReader.close();
            response.close();
            status = responseJson.getString("status").equals("Complete");
            try {
                Thread.sleep(frequency);
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
            totalTime += frequency;
        }
        return status;
    }

    public static boolean checkModelStatusFailed(String modelName, MLHttpClient mlHttpclient, long timeout, int frequency) throws MLHttpClientException, JSONException, IOException {
        boolean status = false;
        int totalTime = 0;
        while (!status && timeout >= (long)totalTime) {
            CloseableHttpResponse response = mlHttpclient.doHttpGet("/api/models/" + modelName);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            JSONObject responseJson = new JSONObject(bufferedReader.readLine());
            bufferedReader.close();
            response.close();
            status = responseJson.getString("status").equals("Failed");
            try {
                Thread.sleep(frequency);
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
            totalTime += frequency;
        }
        return status;
    }

    public static boolean checkModelStatus(String modelName, MLHttpClient mlHttpclient) throws MLHttpClientException, JSONException, IOException {
        CloseableHttpResponse response = mlHttpclient.doHttpGet("/api/models/" + modelName);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
        JSONObject responseJson = new JSONObject(bufferedReader.readLine());
        bufferedReader.close();
        response.close();
        boolean status = responseJson.getString("status").equals("Complete");
        return status;
    }

    public static String createModelWithConfigurations(String algorithmName, String algorithmType, String response, String trainDataFraction, int projectID, int versionSetId, MLHttpClient mlHttpclient) throws MLHttpClientException, IOException, JSONException {
        analysisName = algorithmName + versionSetId;
        mlHttpclient.createAnalysis(analysisName, projectID);
        analysisId = mlHttpclient.getAnalysisId(projectID, analysisName);
        return MLTestUtils.createModelWithConfigurations(algorithmName, algorithmType, response, trainDataFraction, projectID, versionSetId, analysisId, mlHttpclient);
    }

    public static String createModelWithConfigurations(String algorithmName, String algorithmType, String response, String trainDataFraction, String normalLabels, String newNormalLabel, String newAnomalyLabel, String normalization, int projectID, int versionSetId, MLHttpClient mlHttpclient) throws MLHttpClientException, IOException, JSONException {
        analysisName = algorithmName + versionSetId;
        mlHttpclient.createAnalysis(analysisName, projectID);
        analysisId = mlHttpclient.getAnalysisId(projectID, analysisName);
        return MLTestUtils.createModelWithConfigurations(algorithmName, algorithmType, response, trainDataFraction, normalLabels, newNormalLabel, newAnomalyLabel, normalization, projectID, versionSetId, analysisId, mlHttpclient);
    }

    public static String createModelWithConfigurations(String algorithmName, String algorithmType, String userVariable, String productVariable, String observations, String type, String trainDataFraction, int projectID, int versionSetId, MLHttpClient mlHttpclient) throws MLHttpClientException, IOException, JSONException {
        analysisName = algorithmName + versionSetId;
        mlHttpclient.createAnalysis(analysisName, projectID);
        analysisId = mlHttpclient.getAnalysisId(projectID, analysisName);
        return MLTestUtils.createModelWithConfigurations(algorithmName, algorithmType, userVariable, productVariable, observations, type, trainDataFraction, projectID, versionSetId, analysisId, mlHttpclient);
    }

    public static String createModelWithConfigurations(String algorithmName, String algorithmType, String response, String trainDataFraction, int projectID, int versionSetId, int analysisId, MLHttpClient mlHttpclient) throws MLHttpClientException, IOException, JSONException {
        mlHttpclient.setFeatureDefaults(analysisId);
        mlHttpclient.setModelConfiguration(analysisId, MLTestUtils.setModelConfigurations(algorithmName, algorithmType, response, trainDataFraction));
        mlHttpclient.doHttpPost("/api/analyses/" + analysisId + "/hyperParams/defaults", null);
        CloseableHttpResponse httpResponse = mlHttpclient.createModel(analysisId, versionSetId);
        modelName = mlHttpclient.getModelName(httpResponse);
        modelId = mlHttpclient.getModelId(modelName);
        return modelName;
    }

    public static String createModelWithConfigurations(String algorithmName, String algorithmType, String response, String trainDataFraction, String normalLabels, String newNormalLabel, String newAnomalyLabel, String normalization, int projectID, int versionSetId, int analysisId, MLHttpClient mlHttpclient) throws MLHttpClientException, IOException, JSONException {
        mlHttpclient.setFeatureDefaults(analysisId);
        mlHttpclient.setModelConfiguration(analysisId, MLTestUtils.setAnomalyDetectionModelConfigurations(algorithmName, algorithmType, response, trainDataFraction, normalLabels, newNormalLabel, newAnomalyLabel, normalization));
        mlHttpclient.doHttpPost("/api/analyses/" + analysisId + "/hyperParams/defaults", null);
        CloseableHttpResponse httpResponse = mlHttpclient.createModel(analysisId, versionSetId);
        modelName = mlHttpclient.getModelName(httpResponse);
        modelId = mlHttpclient.getModelId(modelName);
        return modelName;
    }

    public static String createModelWithConfigurations(String algorithmName, String algorithmType, String userVariable, String productVariable, String observations, String type, String trainDataFraction, int projectID, int versionSetId, int analysisId, MLHttpClient mlHttpclient) throws MLHttpClientException, IOException, JSONException {
        mlHttpclient.setFeatureDefaults(analysisId);
        mlHttpclient.setModelConfiguration(analysisId, MLTestUtils.setModelConfigurations(algorithmName, algorithmType, userVariable, productVariable, observations, type, trainDataFraction));
        mlHttpclient.doHttpPost("/api/analyses/" + analysisId + "/hyperParams/defaults", null);
        CloseableHttpResponse httpResponse = mlHttpclient.createModel(analysisId, versionSetId);
        modelName = mlHttpclient.getModelName(httpResponse);
        modelId = mlHttpclient.getModelId(modelName);
        return modelName;
    }

    public static Map<String, String> setModelConfigurations(String algorithmName, String algorithmType, String response, String trainDataFraction) {
        HashMap<String, String> configurations = new HashMap<String, String>();
        configurations.put("algorithmName", algorithmName);
        configurations.put("algorithmType", algorithmType);
        configurations.put("responseVariable", response);
        configurations.put("trainDataFraction", trainDataFraction);
        return configurations;
    }

    public static Map<String, String> setAnomalyDetectionModelConfigurations(String algorithmName, String algorithmType, String response, String trainDataFraction, String normalLabels, String newNormalLabel, String newAnomalyLabel, String normalization) {
        Map<String, String> configurations = MLTestUtils.setModelConfigurations(algorithmName, algorithmType, response, trainDataFraction);
        configurations.put("normalLabels", normalLabels);
        configurations.put("newNormalLabel", newNormalLabel);
        configurations.put("newAnomalyLabel", newAnomalyLabel);
        configurations.put("normalization", normalization);
        return configurations;
    }

    public static Map<String, String> setModelConfigurations(String algorithmName, String algorithmType, String userVariable, String productVariable, String observations, String type, String trainDataFraction) {
        HashMap<String, String> configurations = new HashMap<String, String>();
        configurations.put("algorithmName", algorithmName);
        configurations.put("algorithmType", algorithmType);
        configurations.put("userVariable", userVariable);
        configurations.put("productVariable", productVariable);
        if (type == "explicit") {
            configurations.put("ratingVariable", observations);
        } else {
            configurations.put("observationList", observations);
        }
        configurations.put("trainDataFraction", trainDataFraction);
        return configurations;
    }
}

