/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ml.dataset.test;

import java.io.IOException;
import javax.ws.rs.core.Response;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.carbon.ml.integration.common.utils.MLBaseTest;
import org.wso2.carbon.ml.integration.common.utils.MLHttpClient;
import org.wso2.carbon.ml.integration.common.utils.exception.MLHttpClientException;
import org.wso2.carbon.ml.integration.common.utils.exception.MLIntegrationBaseTestException;

@Test(groups={"createDatasets"})
public class CreateDatasetTestCase
extends MLBaseTest {
    private MLHttpClient mlHttpclient;

    @BeforeClass(alwaysRun=true)
    public void initTest() throws MLIntegrationBaseTestException {
        super.init();
        this.mlHttpclient = this.getMLHttpClient();
    }

    @Test(description="Create a dataset from a CSV file")
    public void testCreateDatasetFromFile() throws MLHttpClientException, IOException {
        CloseableHttpResponse response = this.mlHttpclient.uploadDatasetFromCSV("Diabetes", "1.0", "artifacts/ML/data/pIndiansDiabetes.csv");
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        response.close();
    }

    @Test(description="Create a dataset from a DAS table", dependsOnMethods={"testCreateDatasetFromFile"})
    public void testCreateDatasetFromDAS() throws MLHttpClientException, IOException {
        CloseableHttpResponse response = this.mlHttpclient.uploadDatasetFromDAS("das_data", "1.0", "STREAMING_DATA");
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        response.close();
    }

    @Test(description="Create a duplicate version of an existing dataset", dependsOnMethods={"testCreateDatasetFromFile"})
    public void testCreateDuplicateDatasetVersion() throws MLHttpClientException, IOException {
        CloseableHttpResponse response = this.mlHttpclient.uploadDatasetFromCSV("Diabetes", "1.0", "artifacts/ML/data/pIndiansDiabetes.csv");
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        response.close();
    }

    @Test(description="Create a dataset without name")
    public void testCreateDatasetWithoutName() throws MLHttpClientException, IOException {
        CloseableHttpResponse response = this.mlHttpclient.uploadDatasetFromCSV(null, "1.0", "artifacts/ML/data/pIndiansDiabetes.csv");
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.BAD_REQUEST.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        response.close();
    }

    @Test(description="Create a dataset without version")
    public void testCreateDatasetWithoutVersion() throws MLHttpClientException, IOException {
        CloseableHttpResponse response = this.mlHttpclient.uploadDatasetFromCSV("SampleDataForCreateDatasetTestCase_3", null, "artifacts/ML/data/pIndiansDiabetes.csv");
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.BAD_REQUEST.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        response.close();
    }

    @Test(description="Create a dataset without datasource")
    public void testCreateDatasetWithoutDataSource() throws MLHttpClientException, IOException {
        CloseableHttpResponse response = this.mlHttpclient.uploadDatasetFromCSV("SampleDataForCreateDatasetTestCase_4", "1.0", null);
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        response.close();
    }

    @Test(description="Create a dataset for an invalid DAS table")
    public void testCreateDatasetForInvalidDASTable() throws MLHttpClientException, IOException {
        CloseableHttpResponse response = this.mlHttpclient.uploadDatasetFromDAS("SampleDataForCreateDatasetTestCase_5", "1.0", "INVALID_TABLE");
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (int)response.getStatusLine().getStatusCode());
        response.close();
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() throws MLHttpClientException {
        super.destroy();
    }
}

