/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ml.lifecycle.test;

import java.io.IOException;
import javax.ws.rs.core.Response;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.json.JSONArray;
import org.json.JSONException;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.carbon.ml.MLTestUtils;
import org.wso2.carbon.ml.integration.common.utils.MLBaseTest;
import org.wso2.carbon.ml.integration.common.utils.MLHttpClient;
import org.wso2.carbon.ml.integration.common.utils.exception.MLHttpClientException;
import org.wso2.carbon.ml.integration.common.utils.exception.MLIntegrationBaseTestException;

@Test(groups={"yatchDataset"})
public class Dataset2YachtHydrodynamicsTestCase
extends MLBaseTest {
    private MLHttpClient mlHttpclient;
    private static String modelName;
    private static int modelId;
    private CloseableHttpResponse response;
    private int versionSetId;
    private int projectId;

    @BeforeClass(alwaysRun=true)
    public void initTest() throws MLIntegrationBaseTestException, MLHttpClientException, IOException, JSONException {
        super.init();
        this.mlHttpclient = this.getMLHttpClient();
        String version = "1.0";
        int datasetId = this.createDataset("Yacht_Hydrodynamics", version, "artifacts/ML/data/yachtHydrodynamics.csv");
        this.versionSetId = this.getVersionSetId(datasetId, version);
        this.isDatasetProcessed(this.versionSetId, 120000L, 1000);
        this.projectId = this.createProject("Yacht_Hydrodynamics_Project", "Yacht_Hydrodynamics");
    }

    private void testPredictYacht() throws MLHttpClientException, JSONException {
        String payload = "[[-2.3,0.568,4.78,3.99,3.17,0.125],[-2.3,0.568,4.78,3.99,3.17,0.300]]";
        this.response = this.mlHttpclient.doHttpPost("/api/models/" + modelId + "/predict", payload);
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)this.response.getStatusLine().getStatusCode());
        String reply = this.mlHttpclient.getResponseAsString(this.response);
        JSONArray predictions = new JSONArray(reply);
        AssertJUnit.assertEquals((int)2, (int)predictions.length());
    }

    private void buildModelWithLearningAlgorithm(String algorithmName, String algorithmType) throws MLHttpClientException, IOException, JSONException, InterruptedException {
        modelName = MLTestUtils.createModelWithConfigurations(algorithmName, algorithmType, "ResiduaryResistance", "0.7", this.projectId, this.versionSetId, this.mlHttpclient);
        modelId = this.mlHttpclient.getModelId(modelName);
        this.response = this.mlHttpclient.doHttpPost("/api/models/" + modelId);
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)this.response.getStatusLine().getStatusCode());
        this.response.close();
        boolean status = MLTestUtils.checkModelStatusCompleted(modelName, this.mlHttpclient, 120000L, 1000);
        AssertJUnit.assertEquals((String)"Model building did not complete successfully", (boolean)true, (boolean)status);
    }

    @Test(description="Build a linear regression model and predict for yacht dataset", groups={"createLinearRegressionModelYacht"})
    public void testBuildLinearRegressionModel() throws MLHttpClientException, IOException, JSONException, InterruptedException {
        this.buildModelWithLearningAlgorithm("LINEAR_REGRESSION", "Numerical_Prediction");
        this.testPredictYacht();
        this.testExportAsPMML(modelId);
        this.testPublishAsPMML(modelId);
    }

    @Test(description="Build a ridge regression model and predict for yacht dataset", groups={"createRidgeRegressionModelYacht"})
    public void testBuildRidgeRegressionModel() throws MLHttpClientException, IOException, JSONException, InterruptedException {
        this.buildModelWithLearningAlgorithm("RIDGE_REGRESSION", "Numerical_Prediction");
        this.testPredictYacht();
        this.testExportAsPMML(modelId);
        this.testPublishAsPMML(modelId);
    }

    @Test(description="Build a Lasso regression model and predict for yacht dataset", groups={"createLassoRegressionModelYacht"})
    public void testBuildLassoRegressionModel() throws MLHttpClientException, IOException, JSONException, InterruptedException {
        this.buildModelWithLearningAlgorithm("LASSO_REGRESSION", "Numerical_Prediction");
        this.testPredictYacht();
        this.testExportAsPMML(modelId);
        this.testPublishAsPMML(modelId);
    }

    @Test(description="Build a Random Forest regression model and predict for yacht dataset", groups={"createRandomForestRegressionModelYacht"})
    public void testBuildRandomForestRegressionModel() throws MLHttpClientException, IOException, JSONException, InterruptedException {
        this.buildModelWithLearningAlgorithm("RANDOM_FOREST_REGRESSION", "Numerical_Prediction");
        this.testPredictYacht();
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() throws InterruptedException, MLHttpClientException {
        super.destroy();
    }
}

