/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ml.lifecycle.test;

import java.io.IOException;
import javax.ws.rs.core.Response;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.json.JSONArray;
import org.json.JSONException;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.carbon.ml.MLTestUtils;
import org.wso2.carbon.ml.integration.common.utils.MLBaseTest;
import org.wso2.carbon.ml.integration.common.utils.MLHttpClient;
import org.wso2.carbon.ml.integration.common.utils.exception.MLHttpClientException;
import org.wso2.carbon.ml.integration.common.utils.exception.MLIntegrationBaseTestException;

@Test(groups={"gammaTelescopeDataset"})
public class Dataset5GammaTelescopeTestCase
extends MLBaseTest {
    private MLHttpClient mlHttpclient;
    private static String modelName;
    private static int modelId;
    private CloseableHttpResponse response;
    private int versionSetId;
    private int projectId;

    @BeforeClass(alwaysRun=true)
    public void initTest() throws MLIntegrationBaseTestException, MLHttpClientException, IOException, JSONException {
        super.init();
        this.mlHttpclient = this.getMLHttpClient();
        String version = "1.0";
        int datasetId = this.createDataset("Gamma_Telescope", version, "artifacts/ML/data/gammaTelescope.csv");
        this.versionSetId = this.getVersionSetId(datasetId, version);
        this.isDatasetProcessed(this.versionSetId, 120000L, 1000);
        this.projectId = this.createProject("Gamma_Telescope_Project", "Gamma_Telescope");
    }

    private void testPredictGammaTelescope() throws MLHttpClientException, JSONException {
        String payload = "[[18.8562,16.46,2.4385,0.5282,0.2933,25.1269,-6.5401,-16.9327,11.461,162.848],[191.8036,49.7183,3.0006,0.2093,0.1225,146.2148,143.6098,31.6216,44.3492,245.4199]]";
        this.response = this.mlHttpclient.doHttpPost("/api/models/" + modelId + "/predict", payload);
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)this.response.getStatusLine().getStatusCode());
        String reply = this.mlHttpclient.getResponseAsString(this.response);
        JSONArray predictions = new JSONArray(reply);
        AssertJUnit.assertEquals((int)2, (int)predictions.length());
    }

    private void buildModelWithLearningAlgorithm(String algorithmName, String algorithmType) throws MLHttpClientException, IOException, JSONException, InterruptedException {
        modelName = MLTestUtils.createModelWithConfigurations(algorithmName, algorithmType, "class", "0.7", this.projectId, this.versionSetId, this.mlHttpclient);
        modelId = this.mlHttpclient.getModelId(modelName);
        this.response = this.mlHttpclient.doHttpPost("/api/models/" + modelId);
        AssertJUnit.assertEquals((String)"Unexpected response received", (int)Response.Status.OK.getStatusCode(), (int)this.response.getStatusLine().getStatusCode());
        this.response.close();
        boolean status = MLTestUtils.checkModelStatusCompleted(modelName, this.mlHttpclient, 120000L, 1000);
        AssertJUnit.assertEquals((String)"Model building did not complete successfully", (boolean)true, (boolean)status);
    }

    @Test(description="Build a SVM model and predict for gamma telescope dataset", groups={"createSVMModelGammaTelescope"})
    public void testBuildSVMModel() throws MLHttpClientException, IOException, JSONException, InterruptedException {
        this.buildModelWithLearningAlgorithm("SVM", "Classification");
        this.testPredictGammaTelescope();
        this.testExportAsPMML(modelId);
        this.testPublishAsPMML(modelId);
    }

    @Test(description="Build a Decision Tree model and predict for gamma telescope dataset", groups={"createDecisionTreeModelGammaTelescope"}, dependsOnGroups={"createSVMModelGammaTelescope"})
    public void testBuildDecisionTreeModel() throws MLHttpClientException, IOException, JSONException, InterruptedException {
        this.buildModelWithLearningAlgorithm("DECISION_TREE", "Classification");
        this.testPredictGammaTelescope();
    }

    @Test(description="Build a Logistic Regression model and predict for gamma telescope dataset", groups={"createLogisticRegressionGammaTelescope"}, dependsOnGroups={"createDecisionTreeModelGammaTelescope"})
    public void testBuildLogisticRegressionModel() throws MLHttpClientException, IOException, JSONException, InterruptedException {
        this.buildModelWithLearningAlgorithm("LOGISTIC_REGRESSION", "Classification");
        this.testPredictGammaTelescope();
        this.testExportAsPMML(modelId);
        this.testPublishAsPMML(modelId);
    }

    @Test(description="Build a K-means model", groups={"createKMeansGammaTelescope"}, dependsOnGroups={"createLogisticRegressionGammaTelescope"})
    public void testBuildKMeansModel() throws MLHttpClientException, IOException, JSONException, InterruptedException {
        this.buildModelWithLearningAlgorithm("K_MEANS", "Clustering");
        this.testExportAsPMML(modelId);
        this.testPublishAsPMML(modelId);
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() throws InterruptedException, MLHttpClientException {
        super.destroy();
    }
}

