/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ml.server.manager.extension;

import java.io.File;
import java.io.IOException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.automation.engine.context.AutomationContext;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.engine.exceptions.AutomationFrameworkException;
import org.wso2.carbon.automation.engine.extensions.ExecutionListenerExtension;
import org.wso2.carbon.automation.extensions.servers.carbonserver.TestServerManager;
import org.wso2.carbon.automation.test.utils.common.TestConfigurationProvider;

public class MLServerManagerExtension
extends ExecutionListenerExtension {
    private static final Log log = LogFactory.getLog(MLServerManagerExtension.class);
    private static TestServerManager mlServerManager;

    public void initiate() throws AutomationFrameworkException {
        AutomationContext context;
        try {
            context = new AutomationContext("ML", TestUserMode.SUPER_TENANT_ADMIN);
        }
        catch (XPathExpressionException e) {
            throw new AutomationFrameworkException("Error Initiating Server Information", (Throwable)e);
        }
        if (this.getParameters().get("-DportOffset") == null) {
            this.getParameters().put("-DportOffset", "0");
        }
        mlServerManager = new TestServerManager(context, null, this.getParameters()){

            public void configureServer() throws AutomationFrameworkException {
                String resourcePath = TestConfigurationProvider.getResourceLocation((String)"ML") + File.separator + "das" + File.separator;
                String targetPath = mlServerManager.getCarbonHome() + File.separator + "repository" + File.separator + "database" + File.separator;
                try {
                    FileUtils.copyFileToDirectory((File)new File(resourcePath + "ANALYTICS_EVENT_STORE.h2.db"), (File)new File(targetPath));
                    FileUtils.copyFileToDirectory((File)new File(resourcePath + "ANALYTICS_PROCESSED_DATA_STORE.h2.db"), (File)new File(targetPath));
                    FileUtils.copyFileToDirectory((File)new File(resourcePath + "ANALYTICS_FS_DB.h2.db"), (File)new File(targetPath));
                    log.info((Object)"Successfully copied DAS databases");
                }
                catch (IOException e) {
                    String msg = "Failed to copy DAS databases.";
                    log.error((Object)msg, (Throwable)e);
                    throw new AutomationFrameworkException(msg, (Throwable)e);
                }
            }
        };
    }

    public void onExecutionFinish() throws AutomationFrameworkException {
        mlServerManager.stopServer();
    }

    public void onExecutionStart() throws AutomationFrameworkException {
        try {
            mlServerManager.startServer();
        }
        catch (IOException e) {
            throw new AutomationFrameworkException("Error while starting server", (Throwable)e);
        }
        catch (XPathExpressionException e) {
            throw new AutomationFrameworkException("Error while starting server", (Throwable)e);
        }
    }
}

