/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ml.integration.ui.test.mlui;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openqa.selenium.By;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.carbon.automation.extensions.selenium.BrowserManager;
import org.wso2.carbon.ml.integration.common.utils.MLIntegrationUiBaseTest;
import org.wso2.carbon.ml.integration.ui.pages.exceptions.InvalidPageException;
import org.wso2.carbon.ml.integration.ui.pages.exceptions.MLUIPageCreationException;
import org.wso2.carbon.ml.integration.ui.pages.mlui.MLProjectsPage;
import org.wso2.carbon.ml.integration.ui.pages.mlui.MLUIHomePage;
import org.wso2.carbon.ml.integration.ui.pages.mlui.MLUILoginPage;
import org.wso2.carbon.ml.integration.ui.pages.mlui.analysis.AlgorithmPage;
import org.wso2.carbon.ml.integration.ui.pages.mlui.analysis.AnalysisPage;
import org.wso2.carbon.ml.integration.ui.pages.mlui.analysis.ExplorePage;
import org.wso2.carbon.ml.integration.ui.pages.mlui.analysis.ModelPage;
import org.wso2.carbon.ml.integration.ui.pages.mlui.analysis.ParametersPage;
import org.wso2.carbon.ml.integration.ui.pages.mlui.analysis.PreprocessPage;
import org.wso2.carbon.ml.integration.ui.test.dto.MLAnalysis;
import org.wso2.carbon.ml.integration.ui.test.dto.MLDataset;
import org.wso2.carbon.ml.integration.ui.test.exceptions.CreateAnalysisTestException;

public class CreateAnalysisTestCase
extends MLIntegrationUiBaseTest {
    private static final Log logger = LogFactory.getLog(CreateAnalysisTestCase.class);
    private MLUIHomePage mlUiHomePage;
    private MLProjectsPage mlProjectsPage;
    private PreprocessPage preprocessPage;
    private ExplorePage explorePage;
    private AlgorithmPage algorithmPage;
    private ParametersPage parametersPage;
    private ModelPage modelPage;
    private AnalysisPage analysisPage;

    @BeforeClass(alwaysRun=true)
    public void setUp() throws Exception {
        super.init();
        this.driver = BrowserManager.getWebDriver();
        this.driver.get(this.getMLUiUrl());
    }

    @Test(groups={"wso2.ml.ui"}, description="projects page with previously created project")
    public void testRedirectToProjectsPage() throws CreateAnalysisTestException {
        try {
            MLUILoginPage mlUiLoginPage = new MLUILoginPage(this.driver);
            this.mlUiHomePage = mlUiLoginPage.loginAs(this.userInfo.getUserName(), this.userInfo.getPassword());
            this.mlProjectsPage = this.mlUiHomePage.createProject();
            this.mlProjectsPage.sleepTillPageFound(By.xpath((String)this.mlUIElementMapper.getElement("create.new.analysis")));
            Assert.assertTrue((boolean)this.mlProjectsPage.isElementPresent(By.xpath((String)this.mlUIElementMapper.getElement("create.new.analysis"))), (String)"Previously created project not found");
        }
        catch (InvalidPageException e) {
            throw new CreateAnalysisTestException("Failed to create analysis: ", e);
        }
        catch (MLUIPageCreationException e) {
            throw new CreateAnalysisTestException("Failed to create analysis: ", e);
        }
    }

    @Test(groups={"wso2.ml.ui"}, description="create analysis with empty analysis-name", dependsOnMethods={"testRedirectToProjectsPage"})
    public void testCreateAnalysisEmptyName() throws CreateAnalysisTestException {
        try {
            this.mlProjectsPage.createAnalysis("");
            this.mlProjectsPage.sleepTillPageFound(By.xpath((String)this.mlUIElementMapper.getElement("analysis.input.validation.message")));
            Assert.assertTrue((boolean)this.mlProjectsPage.isElementPresent(By.xpath((String)this.mlUIElementMapper.getElement("analysis.input.validation.message"))), (String)"No input validation for Analysis Name field");
        }
        catch (InvalidPageException e) {
            throw new CreateAnalysisTestException("Failed to validate analysis name field: ", e);
        }
    }

    @Test(groups={"wso2.ml.ui"}, description="create analysis and redirect to preprocess page", dependsOnMethods={"testCreateAnalysisEmptyName"})
    public void testCreateAnalysis() throws CreateAnalysisTestException {
        try {
            this.preprocessPage = this.mlProjectsPage.createAnalysis(MLAnalysis.getAnalysisName());
            this.preprocessPage.sleepTillPageFound(By.xpath((String)this.mlUIElementMapper.getElement("preprocess.page.title")));
            Assert.assertTrue((boolean)this.preprocessPage.isElementPresent(By.xpath((String)this.mlUIElementMapper.getElement("preprocess.page.title"))), (String)"Did not redirect to Preprocess page");
        }
        catch (InvalidPageException e) {
            throw new CreateAnalysisTestException("Failed to create analysis: ", e);
        }
    }

    @Test(groups={"wso2.ml.ui"}, description="navigate to explore page from preprocess page", dependsOnMethods={"testCreateAnalysis"})
    public void testPreprocess() throws CreateAnalysisTestException {
        try {
            this.explorePage = this.preprocessPage.next();
            this.explorePage.sleepTillPageFound(By.xpath((String)this.mlUIElementMapper.getElement("explore.scatter.plot")));
            Assert.assertTrue((boolean)this.explorePage.isElementPresent(By.xpath((String)this.mlUIElementMapper.getElement("explore.scatter.plot"))), (String)"Did not redirect to Explore page");
        }
        catch (InvalidPageException e) {
            throw new CreateAnalysisTestException("Failed to navigate to Explore Page: ", e);
        }
    }

    @Test(groups={"wso2.ml.ui"}, description="navigate to algorithms page from explore page", dependsOnMethods={"testPreprocess"})
    public void testExplore() throws CreateAnalysisTestException {
        try {
            this.algorithmPage = this.explorePage.next();
            this.algorithmPage.sleepTillPageFound(By.xpath((String)this.mlUIElementMapper.getElement("algorithm.page.title")));
            Assert.assertTrue((boolean)this.algorithmPage.isElementPresent(By.xpath((String)this.mlUIElementMapper.getElement("algorithm.page.title"))), (String)"Did not redirect to Algorithms page");
        }
        catch (InvalidPageException e) {
            throw new CreateAnalysisTestException("Failed to navigate to Algorithm Page: ", e);
        }
    }

    @Test(groups={"wso2.ml.ui"}, description="navigate to parameters page from algorithm page", dependsOnMethods={"testExplore"})
    public void testAlgorithm() throws CreateAnalysisTestException {
        try {
            this.parametersPage = this.algorithmPage.next();
            this.parametersPage.sleepTillPageFound(By.xpath((String)this.mlUIElementMapper.getElement("parameters.page.title")));
            Assert.assertTrue((boolean)this.parametersPage.isElementPresent(By.xpath((String)this.mlUIElementMapper.getElement("parameters.page.title"))), (String)"Did not redirect to Parameters page");
        }
        catch (InvalidPageException e) {
            throw new CreateAnalysisTestException("Failed to navigate to Parameters Page: ", e);
        }
    }

    @Test(groups={"wso2.ml.ui"}, description="navigate to model page from parameters page", dependsOnMethods={"testAlgorithm"})
    public void testParameters() throws CreateAnalysisTestException {
        try {
            this.modelPage = this.parametersPage.next();
            this.modelPage.sleepTillPageFound(By.xpath((String)this.mlUIElementMapper.getElement("model.page.title")));
            Assert.assertTrue((boolean)this.modelPage.isElementPresent(By.xpath((String)this.mlUIElementMapper.getElement("model.page.title"))), (String)"Did not redirect to Model page");
        }
        catch (InvalidPageException e) {
            throw new CreateAnalysisTestException("Failed to navigate to Model Page: ", e);
        }
    }

    @Test(groups={"wso2.ml.ui"}, description="navigate to analysis page from model page", dependsOnMethods={"testParameters"})
    public void testModelPage() throws CreateAnalysisTestException {
        try {
            this.analysisPage = this.modelPage.next(MLDataset.getDatasetName() + "-" + MLDataset.getVersion());
            this.analysisPage.sleepTillPageFound(By.xpath((String)this.mlUIElementMapper.getElement("create.model")));
            Assert.assertTrue((boolean)this.analysisPage.isElementPresent(By.xpath((String)this.mlUIElementMapper.getElement("create.model"))), (String)"Did not redirect to Analysis page");
        }
        catch (InvalidPageException e) {
            throw new CreateAnalysisTestException("Failed to navigate to Analysis Page: ", e);
        }
    }

    @Test(groups={"wso2.ml.ui"}, description="create model from an existing analysis", dependsOnMethods={"testModelPage"})
    public void testCreateModelFromExistingAnalysis() throws CreateAnalysisTestException {
        try {
            this.modelPage = this.analysisPage.createModel();
            this.modelPage.sleepTillPageFound(By.xpath((String)this.mlUIElementMapper.getElement("model.page.title")));
            Assert.assertTrue((boolean)this.modelPage.isElementPresent(By.xpath((String)this.mlUIElementMapper.getElement("model.page.title"))), (String)"Did not redirect to Model page");
        }
        catch (InvalidPageException e) {
            throw new CreateAnalysisTestException("Failed to navigate to Model Page: ", e);
        }
    }

    @Test(groups={"wso2.ml.ui"}, description="disable input fields when a model is created from an existing analysis", dependsOnMethods={"testCreateModelFromExistingAnalysis"})
    public void testForDisabledInputFields() throws CreateAnalysisTestException {
        try {
            this.parametersPage = this.modelPage.previous();
            this.parametersPage.sleepTillPageFound(By.xpath((String)this.mlUIElementMapper.getElement("parameters.page.title")));
            Assert.assertFalse((boolean)this.parametersPage.isEnabled(By.xpath((String)this.mlUIElementMapper.getElement("parameters.iterations"))), (String)"Parameters-Iterations input field is not disabled");
            Assert.assertFalse((boolean)this.parametersPage.isEnabled(By.xpath((String)this.mlUIElementMapper.getElement("parameters.learning.rate"))), (String)"Parameters-Learning-rate input field is not disabled");
            Assert.assertFalse((boolean)this.parametersPage.isEnabled(By.xpath((String)this.mlUIElementMapper.getElement("parameters.data.fraction"))), (String)"Parameters-Data-fraction field is not disabled");
        }
        catch (InvalidPageException e) {
            throw new CreateAnalysisTestException("Failed to navigate to Parameters Page: ", e);
        }
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.driver.quit();
    }
}

