/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ml.integration.ui.test.mlui;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openqa.selenium.By;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.carbon.automation.extensions.selenium.BrowserManager;
import org.wso2.carbon.ml.integration.common.utils.MLIntegrationUiBaseTest;
import org.wso2.carbon.ml.integration.ui.pages.exceptions.InvalidPageException;
import org.wso2.carbon.ml.integration.ui.pages.exceptions.MLUIPageCreationException;
import org.wso2.carbon.ml.integration.ui.pages.mlui.MLProjectsPage;
import org.wso2.carbon.ml.integration.ui.pages.mlui.MLUIHomePage;
import org.wso2.carbon.ml.integration.ui.pages.mlui.MLUILoginPage;
import org.wso2.carbon.ml.integration.ui.pages.mlui.NewProjectPage;
import org.wso2.carbon.ml.integration.ui.test.dto.MLProject;
import org.wso2.carbon.ml.integration.ui.test.exceptions.CreateProjectTestException;

public class CreateProjectTestCase
extends MLIntegrationUiBaseTest {
    private static final Log logger = LogFactory.getLog(CreateProjectTestCase.class);
    private MLUIHomePage mlUiHomePage;
    private MLProjectsPage mlProjectsPage;
    private NewProjectPage newProjectPage;

    @BeforeClass(alwaysRun=true)
    public void setUp() throws Exception {
        super.init();
        this.driver = BrowserManager.getWebDriver();
        this.driver.get(this.getMLUiUrl());
    }

    @Test(groups={"wso2.ml.ui"}, description="verify login to ML UI")
    public void testLoginToMLUI() throws CreateProjectTestException {
        try {
            MLUILoginPage mlUiLoginPage = new MLUILoginPage(this.driver);
            Assert.assertTrue((boolean)mlUiLoginPage.isElementPresent(By.xpath((String)this.mlUIElementMapper.getElement("login.title"))), (String)"This is not the login page.");
            this.mlUiHomePage = mlUiLoginPage.loginAs(this.userInfo.getUserName(), this.userInfo.getPassword());
            this.mlUiHomePage.sleepTillPageFound(By.xpath((String)this.mlUIElementMapper.getElement("home.page.projects")));
            Assert.assertTrue((boolean)this.mlUiHomePage.isElementPresent(By.xpath((String)this.mlUIElementMapper.getElement("home.page.projects"))), (String)"Did not redirect to home page.");
        }
        catch (InvalidPageException e) {
            throw new CreateProjectTestException("Login to ML UI failed: ", e);
        }
        catch (MLUIPageCreationException e) {
            throw new CreateProjectTestException("Failed to create a login page: ", e);
        }
    }

    @Test(groups={"wso2.ml.ui"}, description="redirect to projects page", dependsOnMethods={"testLoginToMLUI"})
    public void testRedirectToProjectsPage() throws CreateProjectTestException {
        try {
            this.mlProjectsPage = this.mlUiHomePage.createProject();
            this.mlProjectsPage.sleepTillPageFound(By.xpath((String)this.mlUIElementMapper.getElement("create.new.project")));
            Assert.assertTrue((boolean)this.mlProjectsPage.isElementPresent(By.xpath((String)this.mlUIElementMapper.getElement("create.new.project"))), (String)"Did not redirect to projects page.");
        }
        catch (InvalidPageException e) {
            throw new CreateProjectTestException("Failed to create project: ", e);
        }
    }

    @Test(groups={"wso2.ml.ui"}, description="redirect to create project page", dependsOnMethods={"testRedirectToProjectsPage"})
    public void testRedirectToCreateProject() throws CreateProjectTestException {
        try {
            this.newProjectPage = this.mlProjectsPage.createProject();
            this.newProjectPage.sleepTillPageFound(By.xpath((String)this.mlUIElementMapper.getElement("save.project.button")));
            Assert.assertTrue((boolean)this.newProjectPage.isElementPresent(By.xpath((String)this.mlUIElementMapper.getElement("save.project.button"))), (String)"Did not redirect to Create Project page.");
        }
        catch (InvalidPageException e) {
            throw new CreateProjectTestException("Failed to create project: ", e);
        }
    }

    @Test(groups={"wso2.ml.ui"}, description="verify input validation for empty fields", dependsOnMethods={"testRedirectToCreateProject"})
    public void testCreateProjectWithEmptyName() throws CreateProjectTestException {
        try {
            this.newProjectPage.createNewProject("", "", MLProject.getDatasetName());
            this.newProjectPage.sleepTillPageFound(By.xpath((String)this.mlUIElementMapper.getElement("project.name.error")));
            Assert.assertTrue((boolean)this.newProjectPage.isElementPresent(By.xpath((String)this.mlUIElementMapper.getElement("project.name.error"))), (String)"No validation for project name field");
        }
        catch (InvalidPageException e) {
            throw new CreateProjectTestException("Failed to validate input fields: ", e);
        }
    }

    @Test(groups={"wso2.ml.ui"}, description="verify create new project with all fields filled", dependsOnMethods={"testCreateProjectWithEmptyName"})
    public void testCreateProject() throws CreateProjectTestException {
        try {
            this.mlProjectsPage = this.newProjectPage.createNewProject(MLProject.getProjectName(), MLProject.getProjectDescription(), MLProject.getDatasetName());
            this.mlProjectsPage.sleepTillPageFound(By.xpath((String)this.mlUIElementMapper.getElement("create.new.project")));
            Assert.assertTrue((boolean)this.mlProjectsPage.isElementPresent(By.xpath((String)this.mlUIElementMapper.getElement("create.new.project"))), (String)"Did not redirect to Projects page");
            Assert.assertTrue((this.mlProjectsPage.getElementCount(By.xpath((String)this.mlUIElementMapper.getElement("projects.table"))) > 0 ? 1 : 0) != 0, (String)"Project view table is not populated");
        }
        catch (InvalidPageException e) {
            throw new CreateProjectTestException("Failed to create project: ", e);
        }
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.driver.quit();
    }
}

