/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ml.integration.ui.test.mlui;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openqa.selenium.By;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.carbon.automation.extensions.selenium.BrowserManager;
import org.wso2.carbon.ml.integration.common.utils.MLIntegrationUiBaseTest;
import org.wso2.carbon.ml.integration.ui.pages.exceptions.InvalidPageException;
import org.wso2.carbon.ml.integration.ui.pages.exceptions.MLUIPageCreationException;
import org.wso2.carbon.ml.integration.ui.pages.mlui.DataImportPage;
import org.wso2.carbon.ml.integration.ui.pages.mlui.DatasetVersionPage;
import org.wso2.carbon.ml.integration.ui.pages.mlui.MLDatasetsPage;
import org.wso2.carbon.ml.integration.ui.pages.mlui.MLUIHomePage;
import org.wso2.carbon.ml.integration.ui.pages.mlui.MLUILoginPage;
import org.wso2.carbon.ml.integration.ui.test.dto.MLDataset;
import org.wso2.carbon.ml.integration.ui.test.exceptions.ImportDataTestException;

public class ImportDataTestCase
extends MLIntegrationUiBaseTest {
    private static final Log logger = LogFactory.getLog(ImportDataTestCase.class);
    private MLUIHomePage mlUiHomePage;
    private MLDatasetsPage mlDatasetsPage;
    private DataImportPage dataImportPage;
    private DatasetVersionPage datasetVersionPage;

    @BeforeClass(alwaysRun=true)
    public void setUp() throws Exception {
        super.init();
        this.driver = BrowserManager.getWebDriver();
        this.driver.get(this.getMLUiUrl());
    }

    @Test(groups={"wso2.ml.ui"}, description="verify login to ML UI")
    public void testLoginToMLUI() throws ImportDataTestException {
        try {
            MLUILoginPage mlUiLoginPage = new MLUILoginPage(this.driver);
            Assert.assertTrue((boolean)mlUiLoginPage.isElementPresent(By.xpath((String)this.mlUIElementMapper.getElement("login.title"))), (String)"This is not the login page.");
            this.mlUiHomePage = mlUiLoginPage.loginAs(this.userInfo.getUserName(), this.userInfo.getPassword());
            this.mlUiHomePage.sleepTillPageFound(By.xpath((String)this.mlUIElementMapper.getElement("home.page.projects")));
            Assert.assertTrue((boolean)this.mlUiHomePage.isElementPresent(By.xpath((String)this.mlUIElementMapper.getElement("home.page.projects"))), (String)"Did not redirect to home page.");
        }
        catch (InvalidPageException e) {
            throw new ImportDataTestException("Login to ML UI failed: ", e);
        }
        catch (MLUIPageCreationException e) {
            throw new ImportDataTestException("Failed to create a login page: ", e);
        }
    }

    @Test(groups={"wso2.ml.ui"}, description="redirect to datasets page", dependsOnMethods={"testLoginToMLUI"})
    public void testRedirectToDatasetsPage() throws ImportDataTestException {
        try {
            this.mlDatasetsPage = this.mlUiHomePage.createDataset();
            this.mlDatasetsPage.sleepTillPageFound(By.xpath((String)this.mlUIElementMapper.getElement("create.new.dataset")));
            Assert.assertTrue((boolean)this.mlDatasetsPage.isElementPresent(By.xpath((String)this.mlUIElementMapper.getElement("create.new.dataset"))), (String)"Did not redirect to datasets page.");
        }
        catch (InvalidPageException e) {
            throw new ImportDataTestException("Failed to create dataset: ", e);
        }
    }

    @Test(groups={"wso2.ml.ui"}, description="redirect to create dataset page", dependsOnMethods={"testRedirectToDatasetsPage"})
    public void testRedirectToCreateDataset() throws ImportDataTestException {
        try {
            this.dataImportPage = this.mlDatasetsPage.createDataset();
            this.dataImportPage.sleepTillPageFound(By.xpath((String)this.mlUIElementMapper.getElement("import.dataset.button")));
            Assert.assertTrue((boolean)this.dataImportPage.isElementPresent(By.xpath((String)this.mlUIElementMapper.getElement("import.dataset.button"))), (String)"Did not redirect to Create Dataset page.");
        }
        catch (InvalidPageException e) {
            throw new ImportDataTestException("Failed to create dataset: ", e);
        }
    }

    @Test(groups={"wso2.ml.ui"}, description="verify importing a data-set with all fields filled", dependsOnMethods={"testRedirectToCreateDataset"})
    public void testImportData() throws ImportDataTestException {
        try {
            File dataFile = new File(ImportDataTestCase.class.getResource(MLDataset.getDatasetUrl()).toString());
            this.mlDatasetsPage = this.dataImportPage.importData(dataFile, MLDataset.getDatasetName(), MLDataset.getVersion(), MLDataset.getDescription(), MLDataset.getSourceType(), MLDataset.getDataFormat(), MLDataset.getColumnHeader());
            this.mlDatasetsPage.sleepTillPageFound(By.xpath((String)this.mlUIElementMapper.getElement("create.new.dataset")));
            Assert.assertTrue((boolean)this.mlDatasetsPage.isElementPresent(By.xpath((String)this.mlUIElementMapper.getElement("create.new.dataset"))), (String)"Did not redirect to Datasets page");
            Assert.assertTrue((this.mlDatasetsPage.getElementCount(By.xpath((String)this.mlUIElementMapper.getElement("datasets.table"))) > 0 ? 1 : 0) != 0, (String)"Dataset view table is not populated");
        }
        catch (InvalidPageException e) {
            throw new ImportDataTestException("Failed to import data: ", e);
        }
    }

    @Test(groups={"wso2.ml.ui"}, description="verify uploading a data-set version", dependsOnMethods={"testImportData"})
    public void testCreateDatasetVersion() throws ImportDataTestException {
        try {
            this.mlDatasetsPage.expandDatasetVersions();
            this.datasetVersionPage = this.mlDatasetsPage.createDatasetVersion(MLDataset.getVersion2());
            File dataFile = new File(ImportDataTestCase.class.getResource(MLDataset.getDatasetUrl()).toString());
            this.mlDatasetsPage = this.datasetVersionPage.uploadDatasetVersion(dataFile, MLDataset.getSourceType(), MLDataset.getDataFormat(), MLDataset.getColumnHeader());
            this.mlDatasetsPage.sleepTillPageFound(By.xpath((String)this.mlUIElementMapper.getElement("create.new.dataset")));
            Assert.assertTrue((boolean)this.mlDatasetsPage.isElementPresent(By.xpath((String)this.mlUIElementMapper.getElement("create.new.dataset"))), (String)"Did not redirect to Datasets page");
            this.mlDatasetsPage.expandDatasetVersions();
            Assert.assertTrue((this.mlDatasetsPage.getElementCount(By.xpath((String)this.mlUIElementMapper.getElement("dataset.version.table.row"))) == 2 ? 1 : 0) != 0, (String)"Dataset version table is not populated");
        }
        catch (InvalidPageException e) {
            throw new ImportDataTestException("Failed to create Dataset Version Page: ", e);
        }
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.driver.quit();
    }
}

