/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ml.integration.ui.test.mlui;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openqa.selenium.By;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.carbon.automation.extensions.selenium.BrowserManager;
import org.wso2.carbon.ml.integration.common.utils.MLIntegrationUiBaseTest;
import org.wso2.carbon.ml.integration.ui.pages.exceptions.InvalidPageException;
import org.wso2.carbon.ml.integration.ui.pages.exceptions.MLUIPageCreationException;
import org.wso2.carbon.ml.integration.ui.pages.mlui.MLUIHomePage;
import org.wso2.carbon.ml.integration.ui.pages.mlui.MLUILoginPage;
import org.wso2.carbon.ml.integration.ui.test.exceptions.MLUILoginLogoutTestException;

public class MLUILoginLogoutTestCase
extends MLIntegrationUiBaseTest {
    private static final Log logger = LogFactory.getLog(MLUILoginLogoutTestCase.class);
    MLUIHomePage mlUIHomePage;

    @BeforeClass(alwaysRun=true)
    public void setUp() throws Exception {
        super.init();
        this.driver = BrowserManager.getWebDriver();
        this.driver.get(this.getMLUiUrl());
    }

    @Test(groups={"wso2.ml.ui"}, description="verify login to ML UI")
    public void testLoginToMLUI() throws MLUILoginLogoutTestException {
        try {
            MLUILoginPage mlUiLoginPage = new MLUILoginPage(this.driver);
            Assert.assertTrue((boolean)mlUiLoginPage.isElementPresent(By.xpath((String)this.mlUIElementMapper.getElement("login.title"))), (String)"This is not the login page.");
            this.mlUIHomePage = mlUiLoginPage.loginAs(this.userInfo.getUserName(), this.userInfo.getPassword());
            this.mlUIHomePage.sleepTillPageFound(By.xpath((String)this.mlUIElementMapper.getElement("home.page.projects")));
            Assert.assertTrue((boolean)this.mlUIHomePage.isElementPresent(By.xpath((String)this.mlUIElementMapper.getElement("home.page.projects"))), (String)"Did not redirect to home page.");
        }
        catch (InvalidPageException e) {
            throw new MLUILoginLogoutTestException("Login to ML UI failed: " + e.getMessage(), e);
        }
        catch (MLUIPageCreationException e) {
            throw new MLUILoginLogoutTestException("Failed to create a login page: " + e.getMessage(), e);
        }
    }

    @Test(groups={"wso2.ml.ui"}, description="verify logut from ML UI", dependsOnMethods={"testLoginToMLUI"})
    public void testLogoutFromMLUI() throws MLUILoginLogoutTestException {
        try {
            MLUILoginPage mlUiLoginPage = this.mlUIHomePage.logout();
            mlUiLoginPage.sleepTillPageFound(By.xpath((String)this.mlUIElementMapper.getElement("login.title")));
            Assert.assertTrue((boolean)mlUiLoginPage.isElementPresent(By.xpath((String)this.mlUIElementMapper.getElement("login.title"))), (String)"Not redirected to login page after logout.");
        }
        catch (InvalidPageException e) {
            throw new MLUILoginLogoutTestException("Logout from ML UI failed: " + e.getMessage(), e);
        }
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.driver.quit();
    }
}

