/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ml.integration.ui.pages.carbon;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.wso2.carbon.ml.integration.ui.pages.carbon.CarbonHomePage;
import org.wso2.carbon.ml.integration.ui.pages.carbon.CarbonPage;
import org.wso2.carbon.ml.integration.ui.pages.exceptions.CarbonUIPageCreationException;
import org.wso2.carbon.ml.integration.ui.pages.exceptions.InvalidPageException;

public class CarbonLoginPage
extends CarbonPage {
    private static final Log logger = LogFactory.getLog(CarbonLoginPage.class);

    public CarbonLoginPage(WebDriver driver) throws CarbonUIPageCreationException {
        super(driver);
    }

    public CarbonHomePage loginAs(String userName, String password) throws InvalidPageException {
        try {
            WebElement userNameField = this.driver.findElement(By.xpath((String)this.carbonUIElementMapper.getElement("login.username")));
            WebElement passwordField = this.driver.findElement(By.xpath((String)this.carbonUIElementMapper.getElement("login.password")));
            userNameField.sendKeys(new CharSequence[]{userName});
            passwordField.sendKeys(new CharSequence[]{password});
            this.driver.findElement(By.xpath((String)this.carbonUIElementMapper.getElement("login.sign.in.button"))).click();
            return new CarbonHomePage(this.driver);
        }
        catch (CarbonUIPageCreationException e) {
            throw new InvalidPageException("An error occured while creating a Carbon Home Page: " + e.getMessage(), e);
        }
    }
}

