/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ml.integration.ui.pages.carbon;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.wso2.carbon.ml.integration.common.utils.mapper.CarbonUiElementMapper;
import org.wso2.carbon.ml.integration.ui.pages.exceptions.CarbonUIPageCreationException;

public abstract class CarbonPage {
    private static final Log logger = LogFactory.getLog(CarbonPage.class);
    protected WebDriver driver;
    protected CarbonUiElementMapper carbonUIElementMapper;

    public CarbonPage(WebDriver driver) throws CarbonUIPageCreationException {
        try {
            this.driver = driver;
            this.carbonUIElementMapper = CarbonUiElementMapper.getInstance();
        }
        catch (IOException e) {
            throw new CarbonUIPageCreationException("An error occured while retrieving the Carbon UI element mapper: " + e.getMessage(), e);
        }
    }

    public WebDriver getDriver() {
        return this.driver;
    }

    public boolean isElementPresent(By by) {
        try {
            this.driver.findElement(by);
            return true;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public int getElementCount(By by) {
        return this.driver.findElements(by).size();
    }
}

