/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ml.integration.ui.pages.mlui;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.wso2.carbon.ml.integration.ui.pages.exceptions.InvalidPageException;
import org.wso2.carbon.ml.integration.ui.pages.exceptions.MLUIPageCreationException;
import org.wso2.carbon.ml.integration.ui.pages.mlui.DataImportPage;
import org.wso2.carbon.ml.integration.ui.pages.mlui.DatasetVersionPage;
import org.wso2.carbon.ml.integration.ui.pages.mlui.MLUIPage;

public class MLDatasetsPage
extends MLUIPage {
    private static final Log logger = LogFactory.getLog(MLDatasetsPage.class);

    public MLDatasetsPage(WebDriver driver) throws MLUIPageCreationException {
        super(driver);
    }

    public DataImportPage createDataset() throws InvalidPageException {
        try {
            this.driver.findElement(By.xpath((String)this.mlUIElementMapper.getElement("create.new.dataset"))).click();
            return new DataImportPage(this.driver);
        }
        catch (MLUIPageCreationException e) {
            throw new InvalidPageException("Failed to create Datasets Page: ", e);
        }
    }

    public void expandDatasetVersions() {
        this.driver.findElement(By.xpath((String)this.mlUIElementMapper.getElement("dataset.row"))).click();
    }

    public DatasetVersionPage createDatasetVersion(String datasetVersion) throws InvalidPageException {
        try {
            WebElement datasetVersionElement = this.driver.findElement(By.xpath((String)this.mlUIElementMapper.getElement("dataset.version.input")));
            datasetVersionElement.sendKeys(new CharSequence[]{datasetVersion});
            this.driver.findElement(By.xpath((String)this.mlUIElementMapper.getElement("create.dataset.version"))).click();
            return new DatasetVersionPage(this.driver);
        }
        catch (MLUIPageCreationException e) {
            throw new InvalidPageException("Failed to create Dataset Version Page: ", e);
        }
    }
}

