/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ml.integration.ui.pages.mlui;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.wso2.carbon.ml.integration.ui.pages.exceptions.InvalidPageException;
import org.wso2.carbon.ml.integration.ui.pages.exceptions.MLUIPageCreationException;
import org.wso2.carbon.ml.integration.ui.pages.mlui.MLUIPage;
import org.wso2.carbon.ml.integration.ui.pages.mlui.NewProjectPage;
import org.wso2.carbon.ml.integration.ui.pages.mlui.analysis.PreprocessPage;

public class MLProjectsPage
extends MLUIPage {
    private static final Log logger = LogFactory.getLog(MLProjectsPage.class);

    public MLProjectsPage(WebDriver driver) throws MLUIPageCreationException {
        super(driver);
    }

    public NewProjectPage createProject() throws InvalidPageException {
        try {
            this.driver.findElement(By.xpath((String)this.mlUIElementMapper.getElement("create.new.project"))).click();
            return new NewProjectPage(this.driver);
        }
        catch (MLUIPageCreationException e) {
            throw new InvalidPageException("Failed to create NewProject Page: ", e);
        }
    }

    public PreprocessPage createAnalysis(String analysisName) throws InvalidPageException {
        try {
            WebElement datasetNameElement = this.driver.findElement(By.xpath((String)this.mlUIElementMapper.getElement("analysis.name")));
            datasetNameElement.sendKeys(new CharSequence[]{analysisName});
            this.driver.findElement(By.xpath((String)this.mlUIElementMapper.getElement("create.new.analysis"))).click();
            return new PreprocessPage(this.driver);
        }
        catch (MLUIPageCreationException e) {
            throw new InvalidPageException("Failed to create Preprocess Page: ", e);
        }
    }
}

