/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ml.integration.ui.pages.mlui;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.wso2.carbon.ml.integration.ui.pages.exceptions.InvalidPageException;
import org.wso2.carbon.ml.integration.ui.pages.exceptions.MLUIPageCreationException;
import org.wso2.carbon.ml.integration.ui.pages.mlui.MLDatasetsPage;
import org.wso2.carbon.ml.integration.ui.pages.mlui.MLProjectsPage;
import org.wso2.carbon.ml.integration.ui.pages.mlui.MLUILoginPage;
import org.wso2.carbon.ml.integration.ui.pages.mlui.MLUIPage;

public class MLUIHomePage
extends MLUIPage {
    private static final Log logger = LogFactory.getLog(MLUIHomePage.class);

    public MLUIHomePage(WebDriver driver) throws MLUIPageCreationException {
        super(driver);
    }

    public MLProjectsPage createProject() throws InvalidPageException {
        try {
            this.driver.findElement(By.xpath((String)this.mlUIElementMapper.getElement("home.page.projects"))).click();
            return new MLProjectsPage(this.driver);
        }
        catch (MLUIPageCreationException e) {
            throw new InvalidPageException("Failed to create Projects Page: ", e);
        }
    }

    public MLUILoginPage logout() throws InvalidPageException {
        try {
            this.driver.findElement(By.xpath((String)this.mlUIElementMapper.getElement("logged.in.user"))).click();
            this.driver.findElement(By.xpath((String)this.mlUIElementMapper.getElement("logout"))).click();
            return new MLUILoginPage(this.driver);
        }
        catch (MLUIPageCreationException e) {
            throw new InvalidPageException("Failed to create a Login Page: ", e);
        }
    }

    public MLDatasetsPage createDataset() throws InvalidPageException {
        try {
            this.driver.findElement(By.xpath((String)this.mlUIElementMapper.getElement("home.page.datasets"))).click();
            return new MLDatasetsPage(this.driver);
        }
        catch (MLUIPageCreationException e) {
            throw new InvalidPageException("Failed to create Datasets Page: ", e);
        }
    }
}

