/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ml.integration.ui.pages.mlui;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.wso2.carbon.ml.integration.ui.pages.exceptions.InvalidPageException;
import org.wso2.carbon.ml.integration.ui.pages.exceptions.MLUIPageCreationException;
import org.wso2.carbon.ml.integration.ui.pages.mlui.MLProjectsPage;
import org.wso2.carbon.ml.integration.ui.pages.mlui.MLUIPage;

public class NewProjectPage
extends MLUIPage {
    private static final Log logger = LogFactory.getLog(NewProjectPage.class);

    public NewProjectPage(WebDriver driver) throws MLUIPageCreationException {
        super(driver);
    }

    public MLProjectsPage createNewProject(String projectName, String description, String datasetName) throws InvalidPageException {
        try {
            WebElement projectNameElement = this.driver.findElement(By.xpath((String)this.mlUIElementMapper.getElement("project.name")));
            WebElement descriptionElement = this.driver.findElement(By.xpath((String)this.mlUIElementMapper.getElement("project.description")));
            WebElement datasetNameElement = this.driver.findElement(By.xpath((String)this.mlUIElementMapper.getElement("project.dataset")));
            projectNameElement.sendKeys(new CharSequence[]{projectName});
            descriptionElement.sendKeys(new CharSequence[]{description});
            datasetNameElement.sendKeys(new CharSequence[]{datasetName});
            this.driver.findElement(By.xpath((String)this.mlUIElementMapper.getElement("save.project.button"))).click();
            return new MLProjectsPage(this.driver);
        }
        catch (MLUIPageCreationException e) {
            throw new InvalidPageException("Error occurred while creating new project: ", e);
        }
    }
}

