/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ml.integration.ui.pages.mlui.analysis;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.wso2.carbon.ml.integration.ui.pages.exceptions.InvalidPageException;
import org.wso2.carbon.ml.integration.ui.pages.exceptions.MLUIPageCreationException;
import org.wso2.carbon.ml.integration.ui.pages.mlui.MLUIPage;
import org.wso2.carbon.ml.integration.ui.pages.mlui.analysis.AnalysisPage;
import org.wso2.carbon.ml.integration.ui.pages.mlui.analysis.ParametersPage;

public class ModelPage
extends MLUIPage {
    private static final Log logger = LogFactory.getLog(ModelPage.class);

    public ModelPage(WebDriver driver) throws MLUIPageCreationException {
        super(driver);
    }

    public AnalysisPage next(String datasetVersion) throws InvalidPageException {
        try {
            WebElement datasetVersionElement = this.driver.findElement(By.xpath((String)this.mlUIElementMapper.getElement("model.dataset.version")));
            datasetVersionElement.sendKeys(new CharSequence[]{datasetVersion});
            this.driver.findElement(By.xpath((String)this.mlUIElementMapper.getElement("model.run.button"))).click();
            return new AnalysisPage(this.driver);
        }
        catch (MLUIPageCreationException e) {
            throw new InvalidPageException("Failed to create Analysis Page: ", e);
        }
    }

    public ParametersPage previous() throws InvalidPageException {
        try {
            this.driver.findElement(By.xpath((String)this.mlUIElementMapper.getElement("analysis.previous.button"))).click();
            return new ParametersPage(this.driver);
        }
        catch (MLUIPageCreationException e) {
            throw new InvalidPageException("Failed to create Parameters Page: ", e);
        }
    }
}

