/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ml.integration.ui.pages.mlui;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.wso2.carbon.ml.integration.common.utils.mapper.MlUiElementMapper;
import org.wso2.carbon.ml.integration.ui.pages.exceptions.MLUIPageCreationException;

public abstract class MLUIPage {
    private static final int MAX_WAIT_TIME = 60001;
    private static final Log logger = LogFactory.getLog(MLUIPage.class);
    protected WebDriver driver;
    protected MlUiElementMapper mlUIElementMapper;

    public MLUIPage(WebDriver driver) throws MLUIPageCreationException {
        try {
            this.driver = driver;
            this.mlUIElementMapper = MlUiElementMapper.getInstance();
        }
        catch (IOException e) {
            throw new MLUIPageCreationException("An error occured while retrieving the ML UI element mapper", e);
        }
    }

    public WebDriver getDriver() {
        return this.driver;
    }

    public boolean isElementPresent(By by) {
        try {
            this.driver.findElement(by);
            return true;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public int getElementCount(By by) {
        return this.driver.findElements(by).size();
    }

    public boolean isEnabled(By by) {
        return this.driver.findElement(by).isEnabled();
    }

    public void sleepTillPageFound(By by) {
        int totalTime;
        int t;
        boolean isPageFound = this.isElementPresent(by);
        for (totalTime = 0; !isPageFound && totalTime < 60001; totalTime += t) {
            t = 500;
            try {
                Thread.sleep(t);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            isPageFound = this.isElementPresent(by);
        }
        if (isPageFound) {
            logger.info((Object)("Time taken for redirection : " + totalTime + " ms"));
        } else {
            logger.info((Object)"Page not found");
        }
    }
}

