/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ml.integration.ui.pages.mlui;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.wso2.carbon.ml.integration.ui.pages.exceptions.InvalidPageException;
import org.wso2.carbon.ml.integration.ui.pages.exceptions.MLUIPageCreationException;
import org.wso2.carbon.ml.integration.ui.pages.mlui.MLDatasetsPage;
import org.wso2.carbon.ml.integration.ui.pages.mlui.MLUIPage;

public class DataImportPage
extends MLUIPage {
    private static final Log logger = LogFactory.getLog(DataImportPage.class);

    public DataImportPage(WebDriver driver) throws MLUIPageCreationException {
        super(driver);
    }

    public MLDatasetsPage importData(File dataFile, String datasetName, String version, String description, String sourceType, String dataFormat, String columnHeader) throws InvalidPageException {
        try {
            WebElement datasetNameElement = this.driver.findElement(By.xpath((String)this.mlUIElementMapper.getElement("dataset.name")));
            WebElement datasetVerionElement = this.driver.findElement(By.xpath((String)this.mlUIElementMapper.getElement("dataset.version")));
            WebElement descriptionElement = this.driver.findElement(By.xpath((String)this.mlUIElementMapper.getElement("dataset.description")));
            WebElement sourceTypeElement = this.driver.findElement(By.xpath((String)this.mlUIElementMapper.getElement("dataset.source.type")));
            WebElement pathElement = this.driver.findElement(By.xpath((String)this.mlUIElementMapper.getElement("dataset.path")));
            WebElement dataFormatElement = this.driver.findElement(By.xpath((String)this.mlUIElementMapper.getElement("dataset.data.format")));
            WebElement columnHeaderElement = this.driver.findElement(By.xpath((String)this.mlUIElementMapper.getElement("dataset.column.header")));
            datasetNameElement.sendKeys(new CharSequence[]{datasetName});
            datasetVerionElement.sendKeys(new CharSequence[]{version});
            descriptionElement.sendKeys(new CharSequence[]{description});
            sourceTypeElement.sendKeys(new CharSequence[]{sourceType});
            pathElement.sendKeys(new CharSequence[]{dataFile.getPath()});
            dataFormatElement.sendKeys(new CharSequence[]{dataFormat});
            columnHeaderElement.sendKeys(new CharSequence[]{columnHeader});
            this.driver.findElement(By.xpath((String)this.mlUIElementMapper.getElement("import.dataset.button"))).click();
            return new MLDatasetsPage(this.driver);
        }
        catch (MLUIPageCreationException e) {
            throw new InvalidPageException("Error occurred while importing dataset: ", e);
        }
    }
}

