/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ml.integration.ui.pages.mlui;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.wso2.carbon.ml.integration.ui.pages.exceptions.InvalidPageException;
import org.wso2.carbon.ml.integration.ui.pages.exceptions.MLUIPageCreationException;
import org.wso2.carbon.ml.integration.ui.pages.mlui.MLDatasetsPage;
import org.wso2.carbon.ml.integration.ui.pages.mlui.MLUIPage;

public class DatasetVersionPage
extends MLUIPage {
    private static final Log logger = LogFactory.getLog(DatasetVersionPage.class);

    public DatasetVersionPage(WebDriver driver) throws MLUIPageCreationException {
        super(driver);
    }

    public MLDatasetsPage uploadDatasetVersion(File dataFile, String sourceType, String dataFormat, String columnHeader) throws InvalidPageException {
        try {
            WebElement sourceTypeElement = this.driver.findElement(By.xpath((String)this.mlUIElementMapper.getElement("dataset.source.type")));
            WebElement pathElement = this.driver.findElement(By.xpath((String)this.mlUIElementMapper.getElement("dataset.path")));
            WebElement dataFormatElement = this.driver.findElement(By.xpath((String)this.mlUIElementMapper.getElement("dataset.data.format")));
            WebElement columnHeaderElement = this.driver.findElement(By.xpath((String)this.mlUIElementMapper.getElement("dataset.column.header")));
            sourceTypeElement.sendKeys(new CharSequence[]{sourceType});
            pathElement.sendKeys(new CharSequence[]{dataFile.getPath()});
            dataFormatElement.sendKeys(new CharSequence[]{dataFormat});
            columnHeaderElement.sendKeys(new CharSequence[]{columnHeader});
            this.driver.findElement(By.xpath((String)this.mlUIElementMapper.getElement("create.dataset.version.button"))).click();
            return new MLDatasetsPage(this.driver);
        }
        catch (MLUIPageCreationException e) {
            throw new InvalidPageException("Error occurred while uploading dataset version: ", e);
        }
    }
}

